/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.auditing.AudioAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.AuditingAudio;
import com.qcloud.cos.model.ciModel.auditing.AuditingCosOutput;
import com.qcloud.cos.model.ciModel.auditing.AuditingImage;
import com.qcloud.cos.model.ciModel.auditing.AuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.AuditingLiveOutput;
import com.qcloud.cos.model.ciModel.auditing.AuditingSnapshotObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.Conf;
import com.qcloud.cos.model.ciModel.auditing.DocumentAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.Encryption;
import com.qcloud.cos.model.ciModel.auditing.Freeze;
import com.qcloud.cos.model.ciModel.auditing.Mask;
import com.qcloud.cos.model.ciModel.auditing.ReportBadCaseRequest;
import com.qcloud.cos.model.ciModel.auditing.StorageConf;
import com.qcloud.cos.model.ciModel.auditing.TextAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.UserInfo;
import com.qcloud.cos.model.ciModel.auditing.VideoAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.WebpageAuditingRequest;
import com.qcloud.cos.model.ciModel.xml.CIMediaXmlFactory;
import java.util.List;

public class CIAuditingXmlFactory {
    public static byte[] convertToXmlByteArray(BatchImageAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        List<BatchImageAuditingInputObject> inputList = request.getInputList();
        for (BatchImageAuditingInputObject inputObject : inputList) {
            xml.start("Input");
            CIMediaXmlFactory.addIfNotNull(xml, "Url", inputObject.getUrl());
            CIMediaXmlFactory.addIfNotNull(xml, "Object", inputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xml, "DataId", inputObject.getDataId());
            CIMediaXmlFactory.addIfNotNull(xml, "MaxFrames", inputObject.getMaxFrames());
            CIMediaXmlFactory.addIfNotNull(xml, "Interval", inputObject.getInterval());
            CIMediaXmlFactory.addIfNotNull(xml, "LargeImageDetect", inputObject.getLargeImageDetect());
            CIMediaXmlFactory.addIfNotNull(xml, "Content", inputObject.getContent());
            CIAuditingXmlFactory.addUserInfo(xml, inputObject.getUserInfo());
            CIAuditingXmlFactory.addEncryption(xml, inputObject.getEncryption());
            xml.end();
        }
        CIAuditingXmlFactory.addAuditingConf(xml, request.getConf());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(TextAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xml, request.getInput());
        CIAuditingXmlFactory.addAuditingConf(xml, request.getConf());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(DocumentAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        xml.start("Input");
        CIMediaXmlFactory.addIfNotNull(xml, "Url", request.getInput().getUrl());
        CIMediaXmlFactory.addIfNotNull(xml, "Object", request.getInput().getObject());
        CIMediaXmlFactory.addIfNotNull(xml, "Type", request.getInput().getType());
        CIMediaXmlFactory.addIfNotNull(xml, "DataId", request.getInput().getDataId());
        CIAuditingXmlFactory.addUserInfo(xml, request.getInput().getUserInfo());
        xml.end();
        CIAuditingXmlFactory.addAuditingConf(xml, request.getConf());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(AudioAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xml, request.getInput());
        CIAuditingXmlFactory.addAuditingConf(xml, request.getConf());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(ReportBadCaseRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIMediaXmlFactory.addIfNotNull(xml, "ContentType", request.getContentType());
        CIMediaXmlFactory.addIfNotNull(xml, "Text", request.getText());
        CIMediaXmlFactory.addIfNotNull(xml, "Label", request.getLabel());
        CIMediaXmlFactory.addIfNotNull(xml, "SuggestedLabel", (Object)request.getSuggestedLabel());
        CIMediaXmlFactory.addIfNotNull(xml, "JobId", request.getJobId());
        CIMediaXmlFactory.addIfNotNull(xml, "ModerationTime", request.getModerationTime());
        CIMediaXmlFactory.addIfNotNull(xml, "Url", request.getUrl());
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(VideoAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIMediaXmlFactory.addIfNotNull(xml, "Type", request.getType());
        CIAuditingXmlFactory.addAuditingInput(xml, request.getInput());
        CIAuditingXmlFactory.addAuditingConf(xml, request.getConf());
        CIAuditingXmlFactory.addAuditingStorageConf(xml, request.getStorageConf());
        xml.end();
        System.out.println(xml);
        return xml.getBytes();
    }

    private static void addAuditingStorageConf(XmlWriter xml, StorageConf storageConf) {
        if (CIMediaXmlFactory.objIsNotValid(storageConf).booleanValue()) {
            xml.start("StorageConf");
            CIMediaXmlFactory.addIfNotNull(xml, "Path", storageConf.getPath());
            xml.end();
        }
    }

    public static byte[] convertToXmlByteArray(WebpageAuditingRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIAuditingXmlFactory.addAuditingInput(xml, request.getInput());
        CIAuditingXmlFactory.addAuditingConf(xml, request.getConf());
        xml.end();
        return xml.getBytes();
    }

    private static void addUserInfo(XmlWriter xml, UserInfo userInfo) {
        if (CIMediaXmlFactory.objIsNotValid(userInfo).booleanValue()) {
            xml.start("UserInfo");
            CIMediaXmlFactory.addIfNotNull(xml, "TokenId", userInfo.getTokenId());
            CIMediaXmlFactory.addIfNotNull(xml, "Nickname", userInfo.getNickname());
            CIMediaXmlFactory.addIfNotNull(xml, "DeviceId", userInfo.getDeviceId());
            CIMediaXmlFactory.addIfNotNull(xml, "AppId", userInfo.getAppId());
            CIMediaXmlFactory.addIfNotNull(xml, "Room", userInfo.getRoom());
            CIMediaXmlFactory.addIfNotNull(xml, "IP", userInfo.getIp());
            CIMediaXmlFactory.addIfNotNull(xml, "Type", userInfo.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "ReceiveTokenId", userInfo.getReceiveTokenId());
            CIMediaXmlFactory.addIfNotNull(xml, "Gender", userInfo.getGender());
            CIMediaXmlFactory.addIfNotNull(xml, "Level", userInfo.getLevel());
            CIMediaXmlFactory.addIfNotNull(xml, "Role", userInfo.getRole());
            xml.end();
        }
    }

    private static void addAuditingDetectType(XmlWriter xml, String detectType) {
        if (!"all".equalsIgnoreCase(detectType)) {
            CIMediaXmlFactory.addIfNotNull(xml, "DetectType", detectType);
        }
    }

    private static void addAuditingInput(XmlWriter xml, AuditingInputObject inputObject) {
        if (CIMediaXmlFactory.objIsNotValid(inputObject).booleanValue()) {
            xml.start("Input");
            CIMediaXmlFactory.addIfNotNull(xml, "Object", inputObject.getObject());
            CIMediaXmlFactory.addIfNotNull(xml, "Url", inputObject.getUrl());
            CIMediaXmlFactory.addIfNotNull(xml, "DataId", inputObject.getDataId());
            CIMediaXmlFactory.addIfNotNull(xml, "Content", inputObject.getContent());
            CIAuditingXmlFactory.addUserInfo(xml, inputObject.getUserInfo());
            CIAuditingXmlFactory.addEncryption(xml, inputObject.getEncryption());
            xml.end();
        }
    }

    private static void addEncryption(XmlWriter xml, Encryption encryption) {
        if (CIMediaXmlFactory.objIsNotValid(encryption).booleanValue()) {
            xml.start("Encryption");
            CIMediaXmlFactory.addIfNotNull(xml, "Algorithm", encryption.getAlgorithm());
            CIMediaXmlFactory.addIfNotNull(xml, "IV", encryption.getIV());
            CIMediaXmlFactory.addIfNotNull(xml, "Key", encryption.getKey());
            CIMediaXmlFactory.addIfNotNull(xml, "KeyId", encryption.getKeyId());
            CIMediaXmlFactory.addIfNotNull(xml, "KeyType", encryption.getKeyType());
            xml.end();
        }
    }

    private static void addAuditingConf(XmlWriter xml, Conf conf) {
        if (CIMediaXmlFactory.objIsNotValid(conf).booleanValue()) {
            xml.start("Conf");
            String detectType = conf.getDetectType();
            CIAuditingXmlFactory.addAuditingDetectType(xml, detectType);
            CIMediaXmlFactory.addIfNotNull(xml, "BizType", conf.getBizType());
            CIMediaXmlFactory.addIfNotNull(xml, "DetectContent", conf.getDetectContent());
            CIMediaXmlFactory.addIfNotNull(xml, "CallbackVersion", (Object)conf.getCallbackVersion());
            CIMediaXmlFactory.addIfNotNull(xml, "Callback", conf.getCallback());
            CIMediaXmlFactory.addIfNotNull(xml, "ReturnHighlightHtml", conf.getReturnHighlightHtml());
            CIMediaXmlFactory.addIfNotNull(xml, "Async", conf.getAsync());
            CIMediaXmlFactory.addIfNotNull(xml, "CallbackType", conf.getCallbackType());
            CIAuditingXmlFactory.addAuditingSnapshot(xml, conf.getSnapshot());
            CIAuditingXmlFactory.addFreeze(xml, conf.getFreeze());
            CIAuditingXmlFactory.addMask(xml, conf.getMask());
            xml.end();
        }
    }

    private static void addMask(XmlWriter xml, Mask mask) {
        if (CIMediaXmlFactory.objIsNotValid(mask).booleanValue()) {
            xml.start("Mask");
            CIAuditingXmlFactory.addAuditingImage(xml, mask.getImages());
            CIAuditingXmlFactory.addAuditingAudio(xml, mask.getAudios());
            CIAuditingXmlFactory.addCosOutput(xml, mask.getCosOutput());
            CIAuditingXmlFactory.addLiveOutput(xml, mask.getLiveOutput());
            xml.end();
        }
    }

    private static void addLiveOutput(XmlWriter xml, AuditingLiveOutput liveOutput) {
        if (CIMediaXmlFactory.objIsNotValid(liveOutput).booleanValue()) {
            xml.start("LiveOutput");
            CIMediaXmlFactory.addIfNotNull(xml, "Url", liveOutput.getUrl());
            CIMediaXmlFactory.addTranscode(xml, liveOutput.getTranscode());
            xml.end();
        }
    }

    private static void addCosOutput(XmlWriter xml, AuditingCosOutput cosOutput) {
        if (CIMediaXmlFactory.objIsNotValid(cosOutput).booleanValue()) {
            xml.start("CosOutput");
            CIMediaXmlFactory.addIfNotNull(xml, "Bucket", cosOutput.getBucket());
            CIMediaXmlFactory.addIfNotNull(xml, "Region", cosOutput.getRegion());
            CIMediaXmlFactory.addIfNotNull(xml, "Object", cosOutput.getObject());
            CIMediaXmlFactory.addTranscode(xml, cosOutput.getTranscode());
            xml.end();
        }
    }

    private static void addAuditingAudio(XmlWriter xml, List<AuditingAudio> audios) {
        if (audios != null && !audios.isEmpty()) {
            for (AuditingAudio audio : audios) {
                xml.start("Audios");
                CIMediaXmlFactory.addIfNotNull(xml, "Label", audio.getLabel());
                CIMediaXmlFactory.addIfNotNull(xml, "Type", audio.getType());
                xml.end();
            }
        }
    }

    private static void addAuditingImage(XmlWriter xml, List<AuditingImage> images) {
        if (images != null && !images.isEmpty()) {
            for (AuditingImage image : images) {
                xml.start("Images");
                CIMediaXmlFactory.addIfNotNull(xml, "Label", image.getLabel());
                CIMediaXmlFactory.addIfNotNull(xml, "Type", image.getType());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                xml.end();
            }
        }
    }

    private static void addFreeze(XmlWriter xml, Freeze freeze) {
        if (CIMediaXmlFactory.objIsNotValid(freeze).booleanValue()) {
            xml.start("Freeze");
            CIMediaXmlFactory.addIfNotNull(xml, "PornScore", freeze.getPornScore());
            CIMediaXmlFactory.addIfNotNull(xml, "AdsScore", freeze.getAdsScore());
            CIMediaXmlFactory.addIfNotNull(xml, "TerrorismScore", freeze.getTerrorismScore());
            CIMediaXmlFactory.addIfNotNull(xml, "PoliticsScore", freeze.getPoliticsScore());
            xml.end();
        }
    }

    private static void addAuditingSnapshot(XmlWriter xml, AuditingSnapshotObject snapshot) {
        if (CIMediaXmlFactory.objIsNotValid(snapshot).booleanValue()) {
            xml.start("Snapshot");
            CIMediaXmlFactory.addIfNotNull(xml, "Mode", snapshot.getMode());
            CIMediaXmlFactory.addIfNotNull(xml, "TimeInterval", snapshot.getTimeInterval());
            CIMediaXmlFactory.addIfNotNull(xml, "Count", snapshot.getCount());
            xml.end();
        }
    }
}

