/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterials;
import com.qcloud.cos.internal.crypto.StaticEncryptionMaterialsProvider;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SymmetricKeyEncryptionClientDemo {
    private static final String keyFilePath = "secretFolder/secret.key";

    public static void buildAndSaveSymmetricKey() throws IOException, NoSuchAlgorithmException {
        KeyGenerator symKeyGenerator = KeyGenerator.getInstance("AES");
        symKeyGenerator.init(256);
        SecretKey symKey = symKeyGenerator.generateKey();
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(symKey.getEncoded());
        FileOutputStream keyfos = new FileOutputStream(keyFilePath);
        keyfos.write(x509EncodedKeySpec.getEncoded());
        keyfos.close();
    }

    public static SecretKey loadSymmetricAESKey() throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        File keyFile = new File(keyFilePath);
        FileInputStream keyfis = new FileInputStream(keyFile);
        byte[] encodedPrivateKey = new byte[(int)keyFile.length()];
        keyfis.read(encodedPrivateKey);
        keyfis.close();
        return new SecretKeySpec(encodedPrivateKey, "AES");
    }

    public static void main(String[] args) throws Exception {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXXXXXXXXXX", "YYZZZZZZZZZZZZZZZZZ");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        SecretKey symKey = SymmetricKeyEncryptionClientDemo.loadSymmetricAESKey();
        EncryptionMaterials encryptionMaterials = new EncryptionMaterials(symKey);
        CryptoConfiguration cryptoConf = new CryptoConfiguration(CryptoMode.AuthenticatedEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
        COSEncryptionClient cosEncryptionClient = new COSEncryptionClient(new COSStaticCredentialsProvider(cred), new StaticEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConf);
        String bucketName = "mybucket-1251668577";
        String key = "xxx/yyy/zzz.txt";
        File localFile = new File("src/test/resources/plain.txt");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        cosEncryptionClient.putObject(putObjectRequest);
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        File downloadFile = new File("src/test/resources/downPlain.txt");
        cosEncryptionClient.getObject(getObjectRequest, downloadFile);
        cosEncryptionClient.deleteObject(bucketName, key);
        cosEncryptionClient.shutdown();
    }
}

