/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.CASJobParameters;
import com.qcloud.cos.model.CSVInput;
import com.qcloud.cos.model.CSVOutput;
import com.qcloud.cos.model.InputSerialization;
import com.qcloud.cos.model.JSONInput;
import com.qcloud.cos.model.JSONOutput;
import com.qcloud.cos.model.OutputSerialization;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.RequestProgress;
import com.qcloud.cos.model.RestoreObjectRequest;
import com.qcloud.cos.model.ScanRange;
import com.qcloud.cos.model.SelectObjectContentRequest;
import com.qcloud.cos.model.SelectParameters;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RequestXmlFactory {
    public static byte[] convertToXmlByteArray(List<PartETag> partETags) {
        XmlWriter xml = new XmlWriter();
        xml.start("CompleteMultipartUpload");
        if (partETags != null) {
            Collections.sort(partETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag tag1, PartETag tag2) {
                    if (tag1.getPartNumber() < tag2.getPartNumber()) {
                        return -1;
                    }
                    if (tag1.getPartNumber() > tag2.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (PartETag partEtag : partETags) {
                xml.start("Part");
                xml.start("PartNumber").value(Integer.toString(partEtag.getPartNumber())).end();
                xml.start("ETag").value(partEtag.getETag()).end();
                xml.end();
            }
        }
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(SelectObjectContentRequest selectRequest) {
        XmlWriter xml = new XmlWriter();
        xml.start("SelectObjectContentRequest");
        RequestXmlFactory.addIfNotNull(xml, "Expression", selectRequest.getExpression());
        RequestXmlFactory.addIfNotNull(xml, "ExpressionType", selectRequest.getExpressionType());
        RequestXmlFactory.addScanRangeIfNotNull(xml, selectRequest.getScanRange());
        RequestXmlFactory.addRequestProgressIfNotNull(xml, selectRequest.getRequestProgress());
        RequestXmlFactory.addInputSerializationIfNotNull(xml, selectRequest.getInputSerialization());
        RequestXmlFactory.addOutputSerializationIfNotNull(xml, selectRequest.getOutputSerialization());
        xml.end();
        return xml.getBytes();
    }

    private static void addRequestProgressIfNotNull(XmlWriter xml, RequestProgress requestProgress) {
        if (requestProgress == null) {
            return;
        }
        xml.start("RequestProgress");
        RequestXmlFactory.addIfNotNull(xml, "Enabled", requestProgress.getEnabled());
        xml.end();
    }

    private static void addSelectParametersIfNotNull(XmlWriter xml, SelectParameters selectParameters) {
        if (selectParameters == null) {
            return;
        }
        xml.start("SelectParameters");
        RequestXmlFactory.addInputSerializationIfNotNull(xml, selectParameters.getInputSerialization());
        RequestXmlFactory.addIfNotNull(xml, "ExpressionType", selectParameters.getExpressionType());
        RequestXmlFactory.addIfNotNull(xml, "Expression", selectParameters.getExpression());
        RequestXmlFactory.addOutputSerializationIfNotNull(xml, selectParameters.getOutputSerialization());
        xml.end();
    }

    private static void addScanRangeIfNotNull(XmlWriter xml, ScanRange scanRange) {
        if (scanRange != null) {
            xml.start("ScanRange");
            RequestXmlFactory.addIfNotNull(xml, "Start", scanRange.getStart());
            RequestXmlFactory.addIfNotNull(xml, "End", scanRange.getEnd());
            xml.end();
        }
    }

    private static void addInputSerializationIfNotNull(XmlWriter xml, InputSerialization inputSerialization) {
        if (inputSerialization != null) {
            xml.start("InputSerialization");
            if (inputSerialization.getCsv() != null) {
                xml.start("CSV");
                CSVInput csvInput = inputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xml, "FileHeaderInfo", csvInput.getFileHeaderInfo());
                RequestXmlFactory.addIfNotNull(xml, "Comments", csvInput.getCommentsAsString());
                RequestXmlFactory.addIfNotNull(xml, "QuoteEscapeCharacter", csvInput.getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xml, "RecordDelimiter", csvInput.getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "FieldDelimiter", csvInput.getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "QuoteCharacter", csvInput.getQuoteCharacterAsString());
                RequestXmlFactory.addIfNotNull(xml, "AllowQuotedRecordDelimiter", csvInput.getAllowQuotedRecordDelimiter());
                xml.end();
            }
            if (inputSerialization.getJson() != null) {
                xml.start("JSON");
                JSONInput jsonInput = inputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xml, "Type", jsonInput.getType());
                xml.end();
            }
            if (inputSerialization.getParquet() != null) {
                xml.start("Parquet");
                xml.end();
            }
            RequestXmlFactory.addIfNotNull(xml, "CompressionType", inputSerialization.getCompressionType());
            xml.end();
        }
    }

    private static void addOutputSerializationIfNotNull(XmlWriter xml, OutputSerialization outputSerialization) {
        if (outputSerialization != null) {
            xml.start("OutputSerialization");
            if (outputSerialization.getCsv() != null) {
                xml.start("CSV");
                CSVOutput csvOutput = outputSerialization.getCsv();
                RequestXmlFactory.addIfNotNull(xml, "QuoteFields", csvOutput.getQuoteFields());
                RequestXmlFactory.addIfNotNull(xml, "QuoteEscapeCharacter", csvOutput.getQuoteEscapeCharacterAsString());
                RequestXmlFactory.addIfNotNull(xml, "RecordDelimiter", csvOutput.getRecordDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "FieldDelimiter", csvOutput.getFieldDelimiterAsString());
                RequestXmlFactory.addIfNotNull(xml, "QuoteCharacter", csvOutput.getQuoteCharacterAsString());
                xml.end();
            }
            if (outputSerialization.getJson() != null) {
                xml.start("JSON");
                JSONOutput jsonOutput = outputSerialization.getJson();
                RequestXmlFactory.addIfNotNull(xml, "RecordDelimiter", jsonOutput.getRecordDelimiterAsString());
                xml.end();
            }
            xml.end();
        }
    }

    public static byte[] convertToXmlByteArray(RestoreObjectRequest restoreObjectRequest) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("RestoreRequest");
        xml.start("Days").value(Integer.toString(restoreObjectRequest.getExpirationInDays())).end();
        CASJobParameters casJobParameters = restoreObjectRequest.getCasJobParameters();
        if (casJobParameters != null) {
            xml.start("CASJobParameters");
            RequestXmlFactory.addIfNotNull(xml, "Tier", casJobParameters.getTier());
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    private static void addIfNotNull(XmlWriter xml, String xmlTag, String value) {
        if (value != null) {
            xml.start(xmlTag).value(value).end();
        }
    }

    private static void addIfNotNull(XmlWriter xml, String xmlTag, Object value) {
        if (value != null && value.toString() != null) {
            xml.start(xmlTag).value(value.toString()).end();
        }
    }
}

