/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECOSKeyManagementParamsProvider;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.region.Region;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CopyObjectRequest
extends CosServiceRequest
implements SSECOSKeyManagementParamsProvider,
Serializable {
    private String sourceAppid;
    private Region sourceBucketRegion;
    private String sourceBucketName;
    private String sourceKey;
    private String sourceVersionId;
    private EndpointBuilder sourceEndpointBuilder;
    private String destinationBucketName;
    private String destinationKey;
    private String storageClass;
    private ObjectMetadata newObjectMetadata;
    private CannedAccessControlList cannedACL;
    private AccessControlList accessControlList;
    private List<String> matchingETagConstraints = new ArrayList<String>();
    private List<String> nonmatchingEtagConstraints = new ArrayList<String>();
    private Date unmodifiedSinceConstraint;
    private Date modifiedSinceConstraint;
    private String redirectLocation;
    private SSECustomerKey sourceSSECustomerKey;
    private SSECustomerKey destinationSSECustomerKey;
    private SSECOSKeyManagementParams sseCOSKeyManagementParams;
    private String metadataDirective;

    public CopyObjectRequest(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        this(null, null, sourceBucketName, sourceKey, null, destinationBucketName, destinationKey);
    }

    public CopyObjectRequest(Region sourceBucketRegion, String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        this(null, sourceBucketRegion, sourceBucketName, sourceKey, null, destinationBucketName, destinationKey);
    }

    public CopyObjectRequest(String sourceAppid, Region sourceBucketRegion, String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) {
        this(sourceAppid, sourceBucketRegion, sourceBucketName, sourceKey, null, destinationBucketName, destinationKey);
    }

    public CopyObjectRequest(String sourceAppid, Region sourceBucketRegion, String sourceBucketName, String sourceKey, String sourceVersionId, String destinationBucketName, String destinationKey) {
        this.sourceAppid = sourceAppid;
        this.sourceBucketRegion = sourceBucketRegion;
        this.sourceBucketName = sourceBucketName;
        this.sourceKey = sourceKey;
        this.sourceVersionId = sourceVersionId;
        this.destinationBucketName = destinationBucketName;
        this.destinationKey = destinationKey;
    }

    public String getSourceAppid() {
        return this.sourceAppid;
    }

    public void setSourceAppid(String sourceAppid) {
        this.sourceAppid = sourceAppid;
    }

    public Region getSourceBucketRegion() {
        return this.sourceBucketRegion;
    }

    public void setSourceBucketRegion(Region sourceBucketRegion) {
        this.sourceBucketRegion = sourceBucketRegion;
    }

    public String getSourceBucketName() {
        return this.sourceBucketName;
    }

    public void setSourceBucketName(String sourceBucketName) {
        this.sourceBucketName = sourceBucketName;
    }

    public CopyObjectRequest withSourceBucketName(String sourceBucketName) {
        this.setSourceBucketName(sourceBucketName);
        return this;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }

    public CopyObjectRequest withSourceKey(String sourceKey) {
        this.setSourceKey(sourceKey);
        return this;
    }

    public String getSourceVersionId() {
        return this.sourceVersionId;
    }

    public void setSourceVersionId(String sourceVersionId) {
        this.sourceVersionId = sourceVersionId;
    }

    public CopyObjectRequest withSourceVersionId(String sourceVersionId) {
        this.setSourceVersionId(sourceVersionId);
        return this;
    }

    public String getDestinationBucketName() {
        return this.destinationBucketName;
    }

    public void setDestinationBucketName(String destinationBucketName) {
        this.destinationBucketName = destinationBucketName;
    }

    public CopyObjectRequest withDestinationBucketName(String destinationBucketName) {
        this.setDestinationBucketName(destinationBucketName);
        return this;
    }

    public String getDestinationKey() {
        return this.destinationKey;
    }

    public void setDestinationKey(String destinationKey) {
        this.destinationKey = destinationKey;
    }

    public CopyObjectRequest withDestinationKey(String destinationKey) {
        this.setDestinationKey(destinationKey);
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public CopyObjectRequest withStorageClass(String storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
    }

    public CopyObjectRequest withStorageClass(StorageClass storageClass) {
        this.setStorageClass(storageClass);
        return this;
    }

    public CannedAccessControlList getCannedAccessControlList() {
        return this.cannedACL;
    }

    public void setCannedAccessControlList(CannedAccessControlList cannedACL) {
        this.cannedACL = cannedACL;
    }

    public CopyObjectRequest withCannedAccessControlList(CannedAccessControlList cannedACL) {
        this.setCannedAccessControlList(cannedACL);
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public CopyObjectRequest withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public ObjectMetadata getNewObjectMetadata() {
        return this.newObjectMetadata;
    }

    public void setNewObjectMetadata(ObjectMetadata newObjectMetadata) {
        this.newObjectMetadata = newObjectMetadata;
    }

    public CopyObjectRequest withNewObjectMetadata(ObjectMetadata newObjectMetadata) {
        this.setNewObjectMetadata(newObjectMetadata);
        return this;
    }

    public List<String> getMatchingETagConstraints() {
        return this.matchingETagConstraints;
    }

    public void setMatchingETagConstraints(List<String> eTagList) {
        this.matchingETagConstraints = eTagList;
    }

    public CopyObjectRequest withMatchingETagConstraint(String eTag) {
        this.matchingETagConstraints.add(eTag);
        return this;
    }

    public List<String> getNonmatchingETagConstraints() {
        return this.nonmatchingEtagConstraints;
    }

    public void setNonmatchingETagConstraints(List<String> eTagList) {
        this.nonmatchingEtagConstraints = eTagList;
    }

    public CopyObjectRequest withNonmatchingETagConstraint(String eTag) {
        this.nonmatchingEtagConstraints.add(eTag);
        return this;
    }

    public Date getUnmodifiedSinceConstraint() {
        return this.unmodifiedSinceConstraint;
    }

    public void setUnmodifiedSinceConstraint(Date date) {
        this.unmodifiedSinceConstraint = date;
    }

    public CopyObjectRequest withUnmodifiedSinceConstraint(Date date) {
        this.setUnmodifiedSinceConstraint(date);
        return this;
    }

    public Date getModifiedSinceConstraint() {
        return this.modifiedSinceConstraint;
    }

    public void setModifiedSinceConstraint(Date date) {
        this.modifiedSinceConstraint = date;
    }

    public CopyObjectRequest withModifiedSinceConstraint(Date date) {
        this.setModifiedSinceConstraint(date);
        return this;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public CopyObjectRequest withRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
        return this;
    }

    public SSECustomerKey getSourceSSECustomerKey() {
        return this.sourceSSECustomerKey;
    }

    public void setSourceSSECustomerKey(SSECustomerKey sourceSSECustomerKey) {
        this.sourceSSECustomerKey = sourceSSECustomerKey;
    }

    public SSECustomerKey getDestinationSSECustomerKey() {
        return this.destinationSSECustomerKey;
    }

    public void setDestinationSSECustomerKey(SSECustomerKey destinationSSECustomerKey) {
        this.destinationSSECustomerKey = destinationSSECustomerKey;
    }

    public SSECOSKeyManagementParams getSseCOSKeyManagementParams() {
        return this.sseCOSKeyManagementParams;
    }

    public void setSseCOSKeyManagementParams(SSECOSKeyManagementParams sseCOSKeyManagementParams) {
        this.sseCOSKeyManagementParams = sseCOSKeyManagementParams;
    }

    @Override
    public SSECOSKeyManagementParams getSSECOSKeyManagementParams() {
        return this.sseCOSKeyManagementParams;
    }

    public EndpointBuilder getSourceEndpointBuilder() {
        return this.sourceEndpointBuilder;
    }

    public void setSourceEndpointBuilder(EndpointBuilder sourceEndpointBuilder) {
        this.sourceEndpointBuilder = sourceEndpointBuilder;
    }

    public String getMetadataDirective() {
        return this.metadataDirective;
    }

    public void setMetadataDirective(String metadataDirective) {
        this.metadataDirective = metadataDirective;
    }

    public CopyObjectRequest withMetadataDirective(String metadataDirective) {
        this.setMetadataDirective(metadataDirective);
        return this;
    }
}

