/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.auth.COSSigner;
import com.qcloud.cos.utils.VersionInfoUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class PostObjectDemo {
    public static void main(String[] args) throws Exception {
        PostObjectDemo.PostObjectUploadDemo();
    }

    private static void PostObjectUploadDemo() throws Exception {
        String bucketName = "mybucket-1251668577";
        String endpoint = "cos.ap-guangzhou.myqcloud.com";
        String key = "images/test.jpg";
        String filename = "test.jpg";
        String inputFilePath = "test.jpg";
        String contentType = "image/jpeg";
        String secretId = "AKIDXXXXXXXX";
        String seretKey = "1A2Z3YYYYYYYYYY";
        long startTimestamp = System.currentTimeMillis() / 1000L;
        long endTimestamp = startTimestamp + 1800L;
        String endTimestampStr = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(endTimestamp * 1000L);
        String keyTime = startTimestamp + ";" + endTimestamp;
        String boundary = "----WebKitFormBoundaryZBPbaoYE2gqeB21N";
        HashMap<String, String> formFields = new HashMap<String, String>();
        formFields.put("q-sign-algorithm", "sha1");
        formFields.put("key", key);
        formFields.put("q-ak", secretId);
        formFields.put("q-key-time", keyTime);
        String policy = "{\n    \"expiration\": \"" + endTimestampStr + "\",\n" + "    \"conditions\": [\n" + "        { \"bucket\": \"" + bucketName + "\" },\n" + "        { \"q-sign-algorithm\": \"sha1\" },\n" + "        { \"q-ak\": \"" + secretId + "\" },\n" + "        { \"q-sign-time\":\"" + keyTime + "\" }\n" + "    ]\n" + "}";
        String encodedPolicy = new String(Base64.encodeBase64((byte[])policy.getBytes()));
        formFields.put("policy", encodedPolicy);
        COSSigner cosSigner = new COSSigner();
        String signature = cosSigner.buildPostObjectSignature(seretKey, keyTime, policy);
        formFields.put("q-signature", signature);
        String formBody = PostObjectDemo.buildPostObjectBody(boundary, formFields, filename, contentType);
        HttpURLConnection conn = null;
        try {
            int readBytes;
            String urlStr = "http://" + bucketName + "." + endpoint;
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("User-Agent", VersionInfoUtils.getUserAgent());
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            ((OutputStream)out).write(formBody.getBytes());
            File file = new File(inputFilePath);
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            byte[] bytes = new byte[4096];
            while ((readBytes = in.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, readBytes);
            }
            in.close();
            byte[] endData = ("\r\n--" + boundary + "--\r\n").getBytes();
            ((OutputStream)out).write(endData);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            for (Map.Entry<String, List<String>> entries : conn.getHeaderFields().entrySet()) {
                String values = "";
                for (String value : entries.getValue()) {
                    values = values + value + ",";
                }
                if (entries.getKey() == null) {
                    System.out.println("reponse line:" + values);
                    continue;
                }
                System.out.println(entries.getKey() + ":" + values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String buildPostObjectBody(String boundary, Map<String, String> formFields, String filename, String contentType) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : formFields.entrySet()) {
            stringBuffer.append("--").append(boundary).append("\r\n");
            stringBuffer.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
            stringBuffer.append(entry.getValue() + "\r\n");
        }
        stringBuffer.append("--").append(boundary).append("\r\n");
        stringBuffer.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + filename + "\"\r\n");
        stringBuffer.append("Content-Type: " + contentType + "\r\n\r\n");
        return stringBuffer.toString();
    }
}

