/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model.ciModel.xml;

import com.qcloud.cos.internal.RequestXmlFactory;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.ciModel.common.MediaInputObject;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.ExtractDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobOperation;
import com.qcloud.cos.model.ciModel.job.MediaJobsRequest;
import com.qcloud.cos.model.ciModel.job.MediaPicProcessTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.template.MediaHlsEncryptObject;
import com.qcloud.cos.model.ciModel.template.MediaSegmentObject;
import com.qcloud.cos.model.ciModel.template.MediaSnapshotObject;
import com.qcloud.cos.model.ciModel.template.MediaTemplateRequest;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkImage;
import com.qcloud.cos.model.ciModel.template.MediaWaterMarkText;
import com.qcloud.cos.model.ciModel.template.MediaWatermark;
import com.qcloud.cos.model.ciModel.template.SpriteSnapshotConfig;
import com.qcloud.cos.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CIMediaXmlFactory {
    static void addIfNotNull(XmlWriter xml, String xmlTag, String value) {
        if (value != null) {
            xml.start(xmlTag).value(value).end();
        }
    }

    static void addIfNotNull(XmlWriter xml, String xmlTag, Object value) {
        if (value != null && value.toString() != null) {
            xml.start(xmlTag).value(value.toString()).end();
        }
    }

    public static byte[] convertToXmlByteArray(MediaJobsRequest request) {
        XmlWriter xml = new XmlWriter();
        xml.start("Request");
        CIMediaXmlFactory.addCommonParams(xml, request);
        CIMediaXmlFactory.addInput(xml, request.getInput());
        CIMediaXmlFactory.addOperation(xml, request);
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(MediaTemplateRequest request) {
        XmlWriter xml = new XmlWriter();
        String tag = request.getTag();
        xml.start("Request");
        xml.start("Tag").value(tag).end();
        xml.start("Name").value(request.getName()).end();
        if ("Animation".equalsIgnoreCase(tag)) {
            xml.start("Container");
            xml.start("Format").value(request.getContainer().getFormat()).end();
            xml.end();
            CIMediaXmlFactory.addVideo(xml, request.getVideo());
            if (CIMediaXmlFactory.objIsNotValid(request.getTimeInterval()).booleanValue()) {
                xml.start("TimeInterval");
                xml.start("Duration").value(request.getTimeInterval().getDuration()).end();
                xml.start("Start").value(request.getTimeInterval().getStart()).end();
                xml.end();
            }
        } else if ("Snapshot".equalsIgnoreCase(tag)) {
            MediaSnapshotObject snapshot = request.getSnapshot();
            CIMediaXmlFactory.addSnapshot(xml, snapshot);
        } else if ("Watermark".equalsIgnoreCase(tag)) {
            xml.start("Watermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Type", request.getWatermark().getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Dx", request.getWatermark().getDx());
            CIMediaXmlFactory.addIfNotNull(xml, "Dy", request.getWatermark().getDy());
            CIMediaXmlFactory.addIfNotNull(xml, "EndTime", request.getWatermark().getEndTime());
            CIMediaXmlFactory.addIfNotNull(xml, "LocMode", request.getWatermark().getLocMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Pos", request.getWatermark().getPos());
            CIMediaXmlFactory.addIfNotNull(xml, "StartTime", request.getWatermark().getStartTime());
            if ("Text".equalsIgnoreCase(request.getWatermark().getType())) {
                xml.start("Text");
                MediaWaterMarkText text = request.getWatermark().getText();
                CIMediaXmlFactory.addIfNotNull(xml, "FontColor", text.getFontColor());
                CIMediaXmlFactory.addIfNotNull(xml, "FontSize", text.getFontSize());
                CIMediaXmlFactory.addIfNotNull(xml, "FontType", text.getFontType());
                CIMediaXmlFactory.addIfNotNull(xml, "Text", text.getText());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", text.getTransparency());
                xml.end();
            } else if ("Image".equalsIgnoreCase(request.getWatermark().getType())) {
                xml.start("Image");
                MediaWaterMarkImage image = request.getWatermark().getImage();
                CIMediaXmlFactory.addIfNotNull(xml, "Height", image.getHeight());
                CIMediaXmlFactory.addIfNotNull(xml, "Mode", image.getMode());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", image.getTransparency());
                CIMediaXmlFactory.addIfNotNull(xml, "Width", image.getWidth());
                CIMediaXmlFactory.addIfNotNull(xml, "Background", image.getBackground());
                xml.end();
            }
            xml.end();
        } else if ("Transcode".equalsIgnoreCase(tag)) {
            CIMediaXmlFactory.addFormat(xml, request.getContainer());
            CIMediaXmlFactory.addTimeInterval(xml, request.getTimeInterval());
            CIMediaXmlFactory.addAudio(xml, request.getAudio());
            CIMediaXmlFactory.addVideo(xml, request.getVideo());
            CIMediaXmlFactory.addTransConfig(xml, request.getTransConfig());
        }
        xml.end();
        return xml.getBytes();
    }

    private static void addOperation(XmlWriter xml, MediaJobsRequest request) {
        MediaJobOperation operation = request.getOperation();
        xml.start("Operation");
        CIMediaXmlFactory.addIfNotNull(xml, "TemplateId", operation.getTemplateId());
        CIMediaXmlFactory.addWatermarkTemplateId(xml, operation.getWatermarkTemplateId());
        CIMediaXmlFactory.addWatermar(xml, operation.getWatermark());
        CIMediaXmlFactory.addWatermarList(xml, operation.getWatermarkList());
        CIMediaXmlFactory.addRemoveWatermark(xml, operation.getRemoveWatermark());
        CIMediaXmlFactory.addConcat(xml, operation.getMediaConcatTemplate());
        CIMediaXmlFactory.addTranscode(xml, operation.getTranscode());
        CIMediaXmlFactory.addExtractDigitalWatermark(xml, operation.getExtractDigitalWatermark());
        CIMediaXmlFactory.addMediaDigitalWatermark(xml, operation.getDigitalWatermark());
        CIMediaXmlFactory.addOutput(xml, operation.getOutput());
        CIMediaXmlFactory.addPicProcess(xml, operation.getPicProcess());
        CIMediaXmlFactory.addSnapshot(xml, operation.getSnapshot());
        CIMediaXmlFactory.addSegment(xml, operation.getSegment());
        xml.end();
    }

    private static void addWatermarList(XmlWriter xml, List<MediaWatermark> watermarkList) {
        if (watermarkList != null && !watermarkList.isEmpty()) {
            for (MediaWatermark mediaWatermark : watermarkList) {
                CIMediaXmlFactory.addWatermar(xml, mediaWatermark);
            }
        }
    }

    private static void addWatermarkTemplateId(XmlWriter xml, List<String> watermarkTemplateId) {
        if (watermarkTemplateId != null && !watermarkTemplateId.isEmpty()) {
            for (String templateId : watermarkTemplateId) {
                xml.start("WatermarkTemplateId").value(templateId).end();
            }
        }
    }

    private static void addConcat(XmlWriter xml, MediaConcatTemplateObject mediaConcatTemplate) {
        if (CIMediaXmlFactory.objIsNotValid(mediaConcatTemplate).booleanValue()) {
            xml.start("ConcatTemplate");
            List<MediaConcatFragmentObject> concatFragmentList = mediaConcatTemplate.getConcatFragmentList();
            for (MediaConcatFragmentObject concatFragment : concatFragmentList) {
                xml.start("ConcatFragment");
                CIMediaXmlFactory.addIfNotNull(xml, "Mode", concatFragment.getMode());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", concatFragment.getUrl());
                xml.end();
            }
            CIMediaXmlFactory.addVideo(xml, mediaConcatTemplate.getVideo());
            CIMediaXmlFactory.addAudio(xml, mediaConcatTemplate.getAudio());
            CIMediaXmlFactory.addIfNotNull(xml, "Index", mediaConcatTemplate.getIndex());
            String format = mediaConcatTemplate.getContainer().getFormat();
            if (!StringUtils.isNullOrEmpty(format)) {
                xml.start("Container");
                xml.start("Format").value(format).end();
                xml.end();
            }
            xml.end();
        }
    }

    private static void addMediaDigitalWatermark(XmlWriter xml, MediaDigitalWatermark digitalWatermark) {
        if (CIMediaXmlFactory.objIsNotValid(digitalWatermark).booleanValue()) {
            xml.start("DigitalWatermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Message", digitalWatermark.getMessage());
            CIMediaXmlFactory.addIfNotNull(xml, "Type", digitalWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Version", digitalWatermark.getVersion());
            xml.end();
        }
    }

    private static void addExtractDigitalWatermark(XmlWriter xml, ExtractDigitalWatermark extractDigitalWatermark) {
        if (extractDigitalWatermark.getType() != null || extractDigitalWatermark.getMessage() != null) {
            xml.start("ExtractDigitalWatermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Message", extractDigitalWatermark.getMessage());
            CIMediaXmlFactory.addIfNotNull(xml, "Type", extractDigitalWatermark.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Version", extractDigitalWatermark.getVersion());
            xml.end();
        }
    }

    private static void addOutput(XmlWriter xml, MediaOutputObject output) {
        if (CIMediaXmlFactory.objIsNotValid(output).booleanValue()) {
            xml.start("Output");
            CIMediaXmlFactory.addIfNotNull(xml, "Region", output.getRegion());
            CIMediaXmlFactory.addIfNotNull(xml, "Object", output.getObject());
            CIMediaXmlFactory.addIfNotNull(xml, "Bucket", output.getBucket());
            CIMediaXmlFactory.addIfNotNull(xml, "SpriteObject", output.getSpriteObject());
            xml.end();
        }
    }

    private static void addSegment(XmlWriter xml, MediaSegmentObject segment) {
        if (CIMediaXmlFactory.objIsNotValid(segment).booleanValue()) {
            xml.start("Segment");
            CIMediaXmlFactory.addIfNotNull(xml, "Duration", segment.getDuration());
            CIMediaXmlFactory.addIfNotNull(xml, "Format", segment.getFormat());
            MediaHlsEncryptObject hlsEncrypt = segment.getHlsEncrypt();
            if (CIMediaXmlFactory.objIsNotValid(hlsEncrypt).booleanValue()) {
                xml.start("HlsEncrypt");
                CIMediaXmlFactory.addIfNotNull(xml, "IsHlsEncrypt", hlsEncrypt.getIsHlsEncrypt());
                CIMediaXmlFactory.addIfNotNull(xml, "UriKey", hlsEncrypt.getUriKey());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addCommonParams(XmlWriter xml, MediaJobsRequest request) {
        if (CIMediaXmlFactory.objIsNotValid(request).booleanValue()) {
            xml.start("Tag").value(request.getTag()).end();
            xml.start("BucketName").value(request.getBucketName()).end();
            xml.start("QueueId").value(request.getQueueId()).end();
            CIMediaXmlFactory.addIfNotNull(xml, "CallBack", request.getCallBack());
        }
    }

    private static void addPicProcess(XmlWriter xml, MediaPicProcessTemplateObject picProcess) {
        if (CIMediaXmlFactory.objIsNotValid(picProcess).booleanValue()) {
            xml.start("PicProcess");
            CIMediaXmlFactory.addIfNotNull(xml, "IsPicInfo", picProcess.getIsPicInfo());
            CIMediaXmlFactory.addIfNotNull(xml, "ProcessRule", picProcess.getIsPicInfo());
            xml.end();
        }
    }

    private static void addTranscode(XmlWriter xml, MediaTranscodeObject transcode) {
        if (CIMediaXmlFactory.objIsNotValid(transcode).booleanValue()) {
            xml.start("Transcode");
            MediaTranscodeVideoObject video = transcode.getVideo();
            MediaAudioObject audio = transcode.getAudio();
            MediaTransConfigObject transConfig = transcode.getTransConfig();
            MediaTimeIntervalObject timeInterval = transcode.getTimeInterval();
            CIMediaXmlFactory.addFormat(xml, transcode.getContainer());
            CIMediaXmlFactory.addTimeInterval(xml, timeInterval);
            CIMediaXmlFactory.addVideo(xml, video);
            CIMediaXmlFactory.addAudio(xml, audio);
            CIMediaXmlFactory.addTransConfig(xml, transConfig);
            xml.end();
        }
    }

    private static void addFormat(XmlWriter xml, MediaContainerObject container) {
        String format = container.getFormat();
        if (format != null) {
            xml.start("Container");
            xml.start("Format").value(format).end();
            if (container.getClipConfig().getDuration() != null) {
                xml.start("ClipConfig");
                xml.start("Duration").value(container.getClipConfig().getDuration()).end();
                xml.end();
            }
            xml.end();
        }
    }

    private static void addSnapshot(XmlWriter xml, MediaSnapshotObject snapshot) {
        if (CIMediaXmlFactory.objIsNotValid(snapshot).booleanValue()) {
            xml.start("Snapshot");
            CIMediaXmlFactory.addIfNotNull(xml, "Mode", snapshot.getMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Count", snapshot.getCount());
            CIMediaXmlFactory.addIfNotNull(xml, "Fps", snapshot.getFps());
            CIMediaXmlFactory.addIfNotNull(xml, "Height", snapshot.getHeight());
            CIMediaXmlFactory.addIfNotNull(xml, "Start", snapshot.getStart());
            CIMediaXmlFactory.addIfNotNull(xml, "TimeInterval", snapshot.getTimeInterval());
            CIMediaXmlFactory.addIfNotNull(xml, "Width", snapshot.getWidth());
            CIMediaXmlFactory.addIfNotNull(xml, "CIParam", snapshot.getCiParam());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckCount", snapshot.getIsCheckCount());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckBlack", snapshot.getIsCheckBlack());
            CIMediaXmlFactory.addIfNotNull(xml, "BlackLevel", snapshot.getBlackLevel());
            CIMediaXmlFactory.addIfNotNull(xml, "PixelBlackThreshold", snapshot.getPixelBlackThreshold());
            CIMediaXmlFactory.addIfNotNull(xml, "SnapshotOutMode", snapshot.getSnapshotOutMode());
            if (CIMediaXmlFactory.objIsNotValid(snapshot.getSnapshotConfig()).booleanValue()) {
                SpriteSnapshotConfig snapshotConfig = snapshot.getSnapshotConfig();
                xml.start("SpriteSnapshotConfig");
                CIMediaXmlFactory.addIfNotNull(xml, "CellWidth", snapshotConfig.getCellWidth());
                CIMediaXmlFactory.addIfNotNull(xml, "CellHeight", snapshotConfig.getCellHeight());
                CIMediaXmlFactory.addIfNotNull(xml, "Padding", snapshotConfig.getPadding());
                CIMediaXmlFactory.addIfNotNull(xml, "Margin", snapshotConfig.getMargin());
                CIMediaXmlFactory.addIfNotNull(xml, "Color", snapshotConfig.getColor());
                CIMediaXmlFactory.addIfNotNull(xml, "Columns", snapshotConfig.getColumns());
                CIMediaXmlFactory.addIfNotNull(xml, "Lines", snapshotConfig.getLines());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addVideo(XmlWriter xml, MediaVideoObject video) {
        if (RequestXmlFactory.CheckObjectUtils.objIsValid(video).booleanValue()) {
            return;
        }
        xml.start("Video");
        CIMediaXmlFactory.addIfNotNull(xml, "Codec", video.getCodec());
        CIMediaXmlFactory.addIfNotNull(xml, "Width", video.getWidth());
        CIMediaXmlFactory.addIfNotNull(xml, "Height", video.getHeight());
        CIMediaXmlFactory.addIfNotNull(xml, "Fps", video.getFps());
        CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", video.getBitrate());
        CIMediaXmlFactory.addIfNotNull(xml, "BufSize", video.getBufSize());
        CIMediaXmlFactory.addIfNotNull(xml, "Crf", video.getCrf());
        CIMediaXmlFactory.addIfNotNull(xml, "Crop", video.getCrop());
        CIMediaXmlFactory.addIfNotNull(xml, "Gop", video.getGop());
        CIMediaXmlFactory.addIfNotNull(xml, "LongShortMode", video.getLongShortMode());
        CIMediaXmlFactory.addIfNotNull(xml, "Maxrate", video.getMaxrate());
        CIMediaXmlFactory.addIfNotNull(xml, "Pad", video.getPad());
        CIMediaXmlFactory.addIfNotNull(xml, "PixFmt", video.getPixFmt());
        CIMediaXmlFactory.addIfNotNull(xml, "Preset", video.getPreset());
        CIMediaXmlFactory.addIfNotNull(xml, "Profile", video.getProfile());
        CIMediaXmlFactory.addIfNotNull(xml, "Qality", video.getQality());
        CIMediaXmlFactory.addIfNotNull(xml, "Quality", video.getQuality());
        CIMediaXmlFactory.addIfNotNull(xml, "Remove", video.getRemove());
        CIMediaXmlFactory.addIfNotNull(xml, "ScanMode", video.getScanMode());
        CIMediaXmlFactory.addIfNotNull(xml, "HlsTsTime", video.getHlsTsTime());
        CIMediaXmlFactory.addIfNotNull(xml, "AnimateFramesPerSecond", video.getAnimateFramesPerSecond());
        CIMediaXmlFactory.addIfNotNull(xml, "AnimateTimeIntervalOfFrame", video.getAnimateTimeIntervalOfFrame());
        CIMediaXmlFactory.addIfNotNull(xml, "AnimateOnlyKeepKeyFrame", video.getAnimateOnlyKeepKeyFrame());
        xml.end();
    }

    private static void addVideo(XmlWriter xml, MediaTranscodeVideoObject video) {
        if (RequestXmlFactory.CheckObjectUtils.objIsValid(video).booleanValue()) {
            return;
        }
        xml.start("Video");
        CIMediaXmlFactory.addIfNotNull(xml, "Codec", video.getCodec());
        CIMediaXmlFactory.addIfNotNull(xml, "Width", video.getWidth());
        CIMediaXmlFactory.addIfNotNull(xml, "Height", video.getHeight());
        CIMediaXmlFactory.addIfNotNull(xml, "Fps", video.getFps());
        CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", video.getBitrate());
        CIMediaXmlFactory.addIfNotNull(xml, "BufSize", video.getBufSize());
        CIMediaXmlFactory.addIfNotNull(xml, "Crf", video.getCrf());
        CIMediaXmlFactory.addIfNotNull(xml, "Gop", video.getGop());
        CIMediaXmlFactory.addIfNotNull(xml, "Maxrate", video.getMaxrate());
        CIMediaXmlFactory.addIfNotNull(xml, "Preset", video.getPreset());
        CIMediaXmlFactory.addIfNotNull(xml, "Profile", video.getProfile());
        CIMediaXmlFactory.addIfNotNull(xml, "Remove", video.getRemove());
        CIMediaXmlFactory.addIfNotNull(xml, "ScanMode", video.getScanMode());
        xml.end();
    }

    private static void addAudio(XmlWriter xml, MediaAudioObject audio) {
        if (CIMediaXmlFactory.objIsNotValid(audio).booleanValue()) {
            xml.start("Audio");
            CIMediaXmlFactory.addIfNotNull(xml, "Bitrate", audio.getBitrate());
            CIMediaXmlFactory.addIfNotNull(xml, "Channels", audio.getChannels());
            CIMediaXmlFactory.addIfNotNull(xml, "Codec", audio.getCodec());
            CIMediaXmlFactory.addIfNotNull(xml, "Profile", audio.getProfile());
            CIMediaXmlFactory.addIfNotNull(xml, "Remove", audio.getRemove());
            CIMediaXmlFactory.addIfNotNull(xml, "Samplerate", audio.getSamplerate());
            xml.end();
        }
    }

    private static void addTimeInterval(XmlWriter xml, MediaTimeIntervalObject timeInterval) {
        if (CIMediaXmlFactory.objIsNotValid(timeInterval).booleanValue()) {
            xml.start("TimeInterval");
            CIMediaXmlFactory.addIfNotNull(xml, "Duration", timeInterval.getDuration());
            CIMediaXmlFactory.addIfNotNull(xml, "Start", timeInterval.getStart());
            xml.end();
        }
    }

    private static void addTransConfig(XmlWriter xml, MediaTransConfigObject transConfig) {
        if (CIMediaXmlFactory.objIsNotValid(transConfig).booleanValue()) {
            xml.start("TransConfig");
            CIMediaXmlFactory.addIfNotNull(xml, "AdjDarMethod", transConfig.getAdjDarMethod());
            CIMediaXmlFactory.addIfNotNull(xml, "AudioBitrateAdjMethod", transConfig.getAudioBitrateAdjMethod());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckAudioBitrate", transConfig.getIsCheckAudioBitrate());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckReso", transConfig.getIsCheckReso());
            CIMediaXmlFactory.addIfNotNull(xml, "IsCheckVideoBitrate", transConfig.getIsCheckVideoBitrate());
            CIMediaXmlFactory.addIfNotNull(xml, "ResoAdjMethod", transConfig.getResoAdjMethod());
            CIMediaXmlFactory.addIfNotNull(xml, "TransMode", transConfig.getTransMode());
            CIMediaXmlFactory.addIfNotNull(xml, "DeleteMetadata", transConfig.getDeleteMetadata());
            CIMediaXmlFactory.addIfNotNull(xml, "IsHdr2Sdr", transConfig.getIsHdr2Sdr());
            CIMediaXmlFactory.addIfNotNull(xml, "HlsEncrypt", transConfig.getHlsEncrypt());
            xml.end();
        }
    }

    private static void addInput(XmlWriter xml, MediaInputObject inputObject) {
        xml.start("Input");
        xml.start("Object").value(inputObject.getObject()).end();
        xml.end();
    }

    private static void addWatermar(XmlWriter xml, MediaWatermark watermark) {
        if (CIMediaXmlFactory.objIsNotValid(watermark).booleanValue()) {
            xml.start("Watermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Type", watermark.getType());
            CIMediaXmlFactory.addIfNotNull(xml, "Dx", watermark.getDx());
            CIMediaXmlFactory.addIfNotNull(xml, "Dy", watermark.getDy());
            CIMediaXmlFactory.addIfNotNull(xml, "EndTime", watermark.getEndTime());
            CIMediaXmlFactory.addIfNotNull(xml, "LocMode", watermark.getLocMode());
            CIMediaXmlFactory.addIfNotNull(xml, "Pos", watermark.getPos());
            CIMediaXmlFactory.addIfNotNull(xml, "StartTime", watermark.getStartTime());
            if ("Text".equalsIgnoreCase(watermark.getType())) {
                MediaWaterMarkText text = watermark.getText();
                xml.start("Text");
                CIMediaXmlFactory.addIfNotNull(xml, "FontColor", text.getFontColor());
                CIMediaXmlFactory.addIfNotNull(xml, "FontSize", text.getFontSize());
                CIMediaXmlFactory.addIfNotNull(xml, "FontType", text.getFontType());
                CIMediaXmlFactory.addIfNotNull(xml, "Text", text.getText());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", text.getTransparency());
                xml.end();
            } else if ("Image".equalsIgnoreCase(watermark.getType())) {
                MediaWaterMarkImage image = watermark.getImage();
                xml.start("Image");
                CIMediaXmlFactory.addIfNotNull(xml, "Height", image.getHeight());
                CIMediaXmlFactory.addIfNotNull(xml, "Mode", image.getMode());
                CIMediaXmlFactory.addIfNotNull(xml, "Transparency", image.getTransparency());
                CIMediaXmlFactory.addIfNotNull(xml, "Url", image.getUrl());
                CIMediaXmlFactory.addIfNotNull(xml, "Width", image.getWidth());
                xml.end();
            }
            xml.end();
        }
    }

    private static void addRemoveWatermark(XmlWriter xml, MediaRemoveWaterMark removeWatermark) {
        if (CIMediaXmlFactory.objIsNotValid(removeWatermark).booleanValue()) {
            xml.start("RemoveWatermark");
            CIMediaXmlFactory.addIfNotNull(xml, "Height", removeWatermark.getHeight());
            CIMediaXmlFactory.addIfNotNull(xml, "Dx", removeWatermark.getDx());
            CIMediaXmlFactory.addIfNotNull(xml, "Dy", removeWatermark.getDy());
            CIMediaXmlFactory.addIfNotNull(xml, "Switch", removeWatermark.get_switch());
            CIMediaXmlFactory.addIfNotNull(xml, "Width", removeWatermark.getWidth());
            xml.end();
        }
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && object.toString().equals("")) {
            return true;
        }
        if (object instanceof Collection && ((Collection)object).isEmpty()) {
            return true;
        }
        if (object instanceof Map && ((Map)object).isEmpty()) {
            return true;
        }
        return object instanceof Object[] && ((Object[])object).length == 0;
    }

    public static Boolean objIsNotValid(Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object o = field.get(obj);
                if (CIMediaXmlFactory.isEmpty(o)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

