/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.ObjectExpirationHeaderHandler;
import com.qcloud.cos.internal.ObjectRestoreHeaderHandler;
import com.qcloud.cos.internal.ResponseMetadata;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.utils.DateUtils;
import com.qcloud.cos.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCosResponseHandler<T>
implements HttpResponseHandler<CosServiceResponse<T>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCosResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected CosServiceResponse<T> parseResponseMetadata(CosHttpResponse response) {
        CosServiceResponse cosResponse = new CosServiceResponse();
        String cosRequestId = response.getHeaders().get("x-cos-request-id");
        String cosTraceId = response.getHeaders().get("x-cos-trace-id");
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("x-cos-request-id", cosRequestId);
        metadataMap.put("x-cos-trace-id", cosTraceId);
        cosResponse.setResponseMetadata(new ResponseMetadata(metadataMap));
        return cosResponse;
    }

    protected void populateObjectMetadata(CosHttpResponse response, ObjectMetadata metadata) {
        for (Map.Entry<String, String> header : response.getHeaders().entrySet()) {
            String key = header.getKey();
            if (key.startsWith("x-cos-meta-")) {
                key = key.substring("x-cos-meta-".length());
                metadata.addUserMetadata(key, header.getValue());
                continue;
            }
            if (ignoredHeaders.contains(key)) continue;
            if (key.equals("Last-Modified")) {
                try {
                    metadata.setHeader(key, DateUtils.parseRFC822Date(header.getValue()));
                }
                catch (Exception pe) {
                    log.warn("Unable to parse last modified date: " + header.getValue(), (Throwable)pe);
                }
                continue;
            }
            if (key.equals("Content-Length")) {
                try {
                    metadata.setHeader(key, Long.parseLong(header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    log.warn("Unable to parse content length: " + header.getValue(), (Throwable)nfe);
                }
                continue;
            }
            if (key.equals("x-cos-delete-marker")) {
                metadata.setDeleteMarker(Boolean.parseBoolean(header.getValue()));
                continue;
            }
            if (key.equals("ETag")) {
                metadata.setHeader(key, StringUtils.removeQuotes(header.getValue()));
                continue;
            }
            if (key.equals("Expires")) {
                try {
                    metadata.setHttpExpiresDate(DateUtils.parseRFC822Date(header.getValue()));
                }
                catch (Exception pe) {
                    log.warn("Unable to parse http expiration date: " + header.getValue(), (Throwable)pe);
                }
                continue;
            }
            if (key.equals("x-cos-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            if (key.equalsIgnoreCase("x-cos-restore")) {
                new ObjectRestoreHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            metadata.setHeader(key, header.getValue());
        }
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-cos-request-id");
        ignoredHeaders.add("x-cos-trace-id");
    }
}

