/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.dlc.auth;

import com.google.common.base.Preconditions;
import com.qcloud.dlc.auth.AbstractDLCCredentialProvider;
import com.qcloud.dlc.auth.IDLCCredentialProvider;
import com.tencentcloudapi.common.Credential;
import org.apache.hadoop.conf.Configuration;

public class SimpleDLCCredentialProvider
extends AbstractDLCCredentialProvider
implements IDLCCredentialProvider {
    private String appId;
    private String secretId;
    private String secretKey;

    @Override
    public void initialize(Configuration conf) {
        String secretId = conf.get("qcloud.dlc.secret-id");
        String secretKey = conf.get("qcloud.dlc.secret-key");
        Preconditions.checkArgument((secretId != null ? 1 : 0) != 0, (Object)"qcloud.dlc.secret-id must be set.");
        Preconditions.checkArgument((secretKey != null ? 1 : 0) != 0, (Object)"qcloud.dlc.secret-key must be set.");
        this.setSecretId(secretId);
        this.setSecretKey(secretKey);
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Override
    public Credential getCredential() {
        return new Credential(this.getSecretId(), this.getSecretKey());
    }
}

