/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.dlc.common;

import com.tencentcloudapi.dlc.v20210125.models.DMSColumn;
import com.tencentcloudapi.dlc.v20210125.models.DMSTable;
import com.tencentcloudapi.dlc.v20210125.models.DMSTableInfo;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSDatabaseResponse;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSTableResponse;
import com.tencentcloudapi.dlc.v20210125.models.KVPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public class Converters {
    public static Database toDatabase(DescribeDMSDatabaseResponse response) {
        Database database = new Database();
        database.setName(response.getName());
        database.setDescription(response.getAsset().getDescription());
        database.setLocationUri(response.getLocation());
        database.setParameters(Converters.toParameters(response.getAsset().getParams()));
        return database;
    }

    public static Map<String, String> toParameters(KVPair[] pairs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (ArrayUtils.isNotEmpty((Object[])pairs)) {
            Arrays.stream(pairs).forEach(pair -> parameters.put(pair.getKey(), pair.getValue()));
        }
        return parameters;
    }

    public static Table toTable(DescribeDMSTableResponse response) {
        Table table = new Table();
        table.setDbName(response.getDbName());
        table.setTableName(response.getName());
        if (response.getAsset() != null) {
            table.setParameters(Converters.toParameters(response.getAsset().getParams()));
        }
        StorageDescriptor sds = Converters.toStorageDescriptor(response);
        table.setSd(sds);
        return table;
    }

    public static Table toTable(DMSTableInfo response) {
        Table table = new Table();
        table.setDbName(response.getTable().getDbName());
        table.setTableName(response.getTable().getName());
        if (response.getAsset() != null) {
            table.setParameters(Converters.toParameters(response.getAsset().getParams()));
        }
        StorageDescriptor sds = Converters.toStorageDescriptor(response.getTable());
        table.setSd(sds);
        return table;
    }

    public static FieldSchema toFieldSchema(DMSColumn column) {
        return new FieldSchema(column.getName(), column.getType(), column.getDescription());
    }

    public static StorageDescriptor toStorageDescriptor(DMSTable table) {
        StorageDescriptor sds = new StorageDescriptor();
        if (ArrayUtils.isNotEmpty((Object[])table.getColumns())) {
            List cols = Arrays.stream(table.getColumns()).map(Converters::toFieldSchema).collect(Collectors.toList());
            sds.setCols(cols);
        }
        if (table.getSds() != null) {
            sds.setLocation(table.getSds().getLocation());
            sds.setInputFormat(table.getSds().getInputFormat());
            sds.setOutputFormat(table.getSds().getOutputFormat());
            sds.setCompressed(table.getSds().getCompressed().booleanValue());
        }
        sds.setSkewedInfo(new SkewedInfo(new ArrayList(), new ArrayList(), new HashMap()));
        return sds;
    }

    public static StorageDescriptor toStorageDescriptor(DescribeDMSTableResponse response) {
        StorageDescriptor sds = new StorageDescriptor();
        if (ArrayUtils.isNotEmpty((Object[])response.getColumns())) {
            List cols = Arrays.stream(response.getColumns()).map(Converters::toFieldSchema).collect(Collectors.toList());
            sds.setCols(cols);
        }
        if (response.getSds() != null) {
            sds.setLocation(response.getSds().getLocation());
            sds.setInputFormat(response.getSds().getInputFormat());
            sds.setOutputFormat(response.getSds().getOutputFormat());
            sds.setCompressed(response.getSds().getCompressed().booleanValue());
        }
        sds.setSkewedInfo(new SkewedInfo(new ArrayList(), new ArrayList(), new HashMap()));
        return sds;
    }
}

