/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.dlc.metastore;

import com.google.common.base.Preconditions;
import com.qcloud.dlc.auth.DLCCredentialProviderFactory;
import com.qcloud.dlc.auth.IDLCCredentialProvider;
import com.qcloud.dlc.auth.SimpleDLCCredentialProvider;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.dlc.v20210125.DlcClient;
import org.apache.directory.api.util.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DLCClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DLCClientFactory.class);
    private final Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public DLCClientFactory(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        this.conf = conf;
    }

    public DlcClient newClient() throws MetaException {
        IDLCCredentialProvider provider = new DLCCredentialProviderFactory().newCredentialProvider(this.conf);
        String region = this.conf.get("qcloud.dlc.region");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"qcloud.dlc.regionmust be set.");
        DlcClient client = new DlcClient(provider.getCredential(), region);
        String endpoint = this.conf.get("qcloud.dlc.endpoint", null);
        if (Strings.isNotEmpty((String)endpoint)) {
            HttpProfile httpProfile = new HttpProfile();
            ClientProfile clientProfile = new ClientProfile("", httpProfile);
            httpProfile.setEndpoint(endpoint);
            client.setClientProfile(clientProfile);
        }
        return client;
    }

    private IDLCCredentialProvider buildDLCCredentialProvider() {
        Class<IDLCCredentialProvider> providerClass = this.conf.getClass("qcloud.dlc.credential.provider.class", SimpleDLCCredentialProvider.class).asSubclass(IDLCCredentialProvider.class);
        return (IDLCCredentialProvider)ReflectionUtils.newInstance(providerClass, (Configuration)this.getConf());
    }
}

