/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.dlc.metastore;

import com.google.common.collect.Lists;
import com.qcloud.dlc.metastore.IQCloudDLCMetastore;
import com.qcloud.dlc.metastore.QCloudDLCMetastoreFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLCDataCatalogMetastoreClient
implements IMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DLCDataCatalogMetastoreClient.class);
    private final Configuration conf;
    private static final String REGEX_MATCH_ALL = ".*";
    private static final String DEFAULT_DATABASE = "default";
    private final IQCloudDLCMetastore dlcMetastore;

    public DLCDataCatalogMetastoreClient(Configuration conf) throws MetaException {
        this.conf = conf;
        this.dlcMetastore = new QCloudDLCMetastoreFactory().newMetastore(conf);
    }

    public boolean isCompatibleWith(HiveConf conf) {
        return false;
    }

    public void setHiveAddedJars(String addedJars) {
        throw new NotImplementedException();
    }

    public boolean isLocalMetaStore() {
        return false;
    }

    public void reconnect() throws MetaException {
    }

    public void close() {
    }

    public void setMetaConf(String key, String value) throws MetaException, TException {
    }

    public String getMetaConf(String key) throws MetaException, TException {
        return null;
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        if (pattern == null || pattern.equals("*")) {
            pattern = REGEX_MATCH_ALL;
        }
        ArrayList databases = Lists.newArrayList();
        for (String name : this.dlcMetastore.getAllDatabases()) {
            if (!Pattern.matches(pattern, name)) continue;
            databases.add(name);
        }
        return databases;
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.getDatabases(null);
    }

    public List<String> getAllTables(String dbName) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbName, null);
    }

    public List<String> getTables(String dbName, String tablePattern) throws MetaException, TException, UnknownDBException {
        List<String> tables = this.dlcMetastore.getTables(dbName, tablePattern).stream().map(Table::getTableName).collect(Collectors.toList());
        return tables;
    }

    public List<String> getTables(String dbName, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbName, tablePattern);
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        throw new UnsupportedOperationException("dropTable is not supported.");
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException {
        throw new UnsupportedOperationException("dropTable is not supported.");
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("dropTable is not supported.");
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("dropTable is not supported.");
    }

    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("dropTable is not supported.");
    }

    public void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("dropTable is not supported.");
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return this.getTable(databaseName, tableName) != null;
    }

    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists(DEFAULT_DATABASE, tableName);
    }

    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable(DEFAULT_DATABASE, tableName);
    }

    public Database getDatabase(String databaseName) throws NoSuchObjectException, MetaException, TException {
        Database database;
        try {
            database = this.dlcMetastore.getDatabase(databaseName);
        }
        catch (Exception e) {
            logger.error("Unable to get database: ", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        return database;
    }

    public Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.dlcMetastore.getTable(dbName, tableName);
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        ArrayList tables = Lists.newArrayList();
        for (String tableName : tableNames) {
            tables.add(this.getTable(dbName, tableName));
        }
        return tables;
    }

    public Partition appendPartition(String tableName, String dbName, List<String> partVals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("appendPartition is not supported.");
    }

    public Partition appendPartition(String tableName, String dbName, String name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("appendPartition is not supported.");
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("add_partition is not supported.");
    }

    public int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("add_partitions is not supported.");
    }

    public int add_partitions_pspec(PartitionSpecProxy partitionSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("add_partitions_pspec is not supported.");
    }

    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResults) throws TException {
        throw new UnsupportedOperationException("add_partitions is not supported.");
    }

    public Partition getPartition(String dbName, String tblName, List<String> partVals) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("getPartition is not supported.");
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("exchange_partition is not supported.");
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTable, String destdb, String destTableName) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException("exchange_partitions is not supported.");
    }

    public Partition getPartition(String dbName, String tblName, String name) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getPartition is not supported.");
    }

    public Partition getPartitionWithAuthInfo(String dbName, String tableName, List<String> pvals, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getPartitionWithAuthInfo is not supported.");
    }

    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("listPartitions is not supported.");
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tableName, int maxParts) throws TException {
        throw new UnsupportedOperationException("listPartitionSpecs is not supported.");
    }

    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("listPartitions is not supported.");
    }

    public List<String> listPartitionNames(String db_name, String tbl_name, short max_parts) throws MetaException, TException {
        throw new UnsupportedOperationException("listPartitionNames is not supported.");
    }

    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("listPartitionNames is not supported.");
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest request) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("listPartitionValues is not supported.");
    }

    public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getNumPartitionsByFilter is not supported.");
    }

    public List<Partition> listPartitionsByFilter(String db_name, String tbl_name, String filter, short max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("listPartitionsByFilter is not supported.");
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String db_name, String tbl_name, String filter, int max_parts) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("listPartitionSpecsByFilter is not supported.");
    }

    public boolean listPartitionsByExpr(String db_name, String tbl_name, byte[] expr, String default_partition_name, short max_parts, List<Partition> result) throws TException {
        throw new UnsupportedOperationException("listPartitionsByExpr is not supported.");
    }

    public List<Partition> listPartitionsWithAuthInfo(String dbName, String tableName, short s, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("listPartitionsWithAuthInfo is not supported.");
    }

    public List<Partition> getPartitionsByNames(String db_name, String tbl_name, List<String> part_names) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("getPartitionsByNames is not supported.");
    }

    public List<Partition> listPartitionsWithAuthInfo(String dbName, String tableName, List<String> partialPvals, short s, String userName, List<String> groupNames) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException("listPartitionsWithAuthInfo is not supported.");
    }

    public void markPartitionForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("markPartitionForEvent is not supported.");
    }

    public boolean isPartitionMarkedForEvent(String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException("getPartitionWithAuthInfo is not supported.");
    }

    public void validatePartitionNameCharacters(List<String> partVals) throws TException, MetaException {
        throw new UnsupportedOperationException("getPartitionWithAuthInfo is not supported.");
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("createTable is not supported.");
    }

    public void alter_table(String defaultDatabaseName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_table is not supported.");
    }

    public void alter_table(String defaultDatabaseName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_table is not supported.");
    }

    public void alter_table_with_environmentContext(String defaultDatabaseName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.dlcMetastore.updateTable(defaultDatabaseName, table);
    }

    public void createDatabase(Database db) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        throw new UnsupportedOperationException("createDatabase is not supported.");
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("dropDatabase is not supported.");
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("dropDatabase is not supported.");
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("dropDatabase is not supported.");
    }

    public void alterDatabase(String name, Database db) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("alterDatabase is not supported.");
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartition is not supported.");
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, PartitionDropOptions options) throws TException {
        throw new UnsupportedOperationException("dropPartition is not supported.");
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartitions is not supported.");
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResults) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartitions is not supported.");
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions options) throws TException {
        throw new UnsupportedOperationException("dropPartitions is not supported.");
    }

    public boolean dropPartition(String db_name, String tbl_name, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropPartition is not supported.");
    }

    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_partition is not supported.");
    }

    public void alter_partition(String dbName, String tblName, Partition newPart, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_partition is not supported.");
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> newParts) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_partitions is not supported.");
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> newParts, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_partitions is not supported.");
    }

    public void renamePartition(String dbname, String name, List<String> part_vals, Partition newPart) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("renamePartition is not supported.");
    }

    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("getFields is not supported.");
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        throw new UnsupportedOperationException("getFields is not supported.");
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        throw new UnsupportedOperationException("getConfigValue is not supported.");
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        throw new UnsupportedOperationException("partitionNameToVals is not supported.");
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        throw new UnsupportedOperationException("partitionNameToSpec is not supported.");
    }

    public void createIndex(Index index, Table indexTable) throws InvalidObjectException, MetaException, NoSuchObjectException, TException, AlreadyExistsException {
        throw new UnsupportedOperationException("createIndex is not supported.");
    }

    public void alter_index(String dbName, String tblName, String indexName, Index index) throws InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException("alter_index is not supported.");
    }

    public Index getIndex(String dbName, String tblName, String indexName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getIndex is not supported.");
    }

    public List<Index> listIndexes(String db_name, String tbl_name, short max) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("listIndexes is not supported.");
    }

    public List<String> listIndexNames(String db_name, String tbl_name, short max) throws MetaException, TException {
        throw new UnsupportedOperationException("listIndexNames is not supported.");
    }

    public boolean dropIndex(String db_name, String tbl_name, String name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("dropIndex is not supported.");
    }

    public boolean updateTableColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("updateTableColumnStatistics is not supported.");
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics statsObj) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("updatePartitionColumnStatistics is not supported.");
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("getTableColumnStatistics is not supported.");
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partNames, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("getPartitionColumnStatistics is not supported.");
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        throw new UnsupportedOperationException("deletePartitionColumnStatistics is not supported.");
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        throw new UnsupportedOperationException("deleteTableColumnStatistics is not supported.");
    }

    public boolean create_role(Role role) throws MetaException, TException {
        throw new UnsupportedOperationException("create_role is not supported.");
    }

    public boolean drop_role(String role_name) throws MetaException, TException {
        throw new UnsupportedOperationException("drop_role is not supported.");
    }

    public List<String> listRoleNames() throws MetaException, TException {
        throw new UnsupportedOperationException("listRoleNames is not supported.");
    }

    public boolean grant_role(String role_name, String user_name, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("grant_role is not supported.");
    }

    public boolean revoke_role(String role_name, String user_name, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("revoke_role is not supported.");
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        throw new UnsupportedOperationException("list_roles is not supported.");
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String user_name, List<String> group_names) throws MetaException, TException {
        throw new UnsupportedOperationException("get_privilege_set is not supported.");
    }

    public List<HiveObjectPrivilege> list_privileges(String principal_name, PrincipalType principal_type, HiveObjectRef hiveObject) throws MetaException, TException {
        throw new UnsupportedOperationException("list_privileges is not supported.");
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        throw new UnsupportedOperationException("grant_privileges is not supported.");
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        throw new UnsupportedOperationException("revoke_privileges is not supported.");
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        throw new UnsupportedOperationException("getDelegationToken is not supported.");
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        throw new UnsupportedOperationException("renewDelegationToken is not supported.");
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        throw new UnsupportedOperationException("cancelDelegationToken is not supported.");
    }

    public String getTokenStrForm() throws IOException {
        throw new UnsupportedOperationException("getTokenStrForm is not supported.");
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        throw new UnsupportedOperationException("addToken is not supported.");
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        throw new UnsupportedOperationException("removeToken is not supported.");
    }

    public String getToken(String tokenIdentifier) throws TException {
        throw new UnsupportedOperationException("getToken is not supported.");
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        throw new UnsupportedOperationException("getAllTokenIdentifiers is not supported.");
    }

    public int addMasterKey(String key) throws MetaException, TException {
        return 0;
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        return false;
    }

    public String[] getMasterKeys() throws TException {
        return new String[0];
    }

    public void createFunction(Function func) throws InvalidObjectException, MetaException, TException {
    }

    public void alterFunction(String dbName, String funcName, Function newFunction) throws InvalidObjectException, MetaException, TException {
    }

    public void dropFunction(String dbName, String funcName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
    }

    public Function getFunction(String dbName, String funcName) throws MetaException, TException {
        return null;
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return null;
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return null;
    }

    public ValidTxnList getValidTxns() throws TException {
        return null;
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return null;
    }

    public long openTxn(String user) throws TException {
        return 0L;
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return null;
    }

    public void rollbackTxn(long txnid) throws NoSuchTxnException, TException {
    }

    public void commitTxn(long txnid) throws NoSuchTxnException, TxnAbortedException, TException {
    }

    public void abortTxns(List<Long> txnids) throws TException {
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return null;
    }

    public LockResponse lock(LockRequest request) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.dlcMetastore.lock(request);
    }

    public LockResponse checkLock(long lockid) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.dlcMetastore.checkLock(lockid);
    }

    public void unlock(long lockid) throws NoSuchLockException, TxnOpenException, TException {
        this.dlcMetastore.unlock(lockid);
    }

    public ShowLocksResponse showLocks() throws TException {
        return null;
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        return null;
    }

    public void heartbeat(long txnid, long lockid) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        this.dlcMetastore.heartbeat(txnid, lockid);
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        return null;
    }

    public void compact(String dbname, String tableName, String partitionName, CompactionType type) throws TException {
    }

    public void compact(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
    }

    public CompactionResponse compact2(String dbname, String tableName, String partitionName, CompactionType type, Map<String, String> tblproperties) throws TException {
        return null;
    }

    public ShowCompactResponse showCompactions() throws TException {
        return null;
    }

    public void addDynamicPartitions(long txnId, String dbName, String tableName, List<String> partNames) throws TException {
        throw new UnsupportedOperationException("addDynamicPartitions is not supported.");
    }

    public void addDynamicPartitions(long txnId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        throw new UnsupportedOperationException("addDynamicPartitions is not supported.");
    }

    public void insertTable(Table table, boolean overwrite) throws MetaException {
        throw new UnsupportedOperationException("insertTable is not supported.");
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter filter) throws TException {
        return null;
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        throw new UnsupportedOperationException("getCurrentNotificationEventId is not supported.");
    }

    public FireEventResponse fireListenerEvent(FireEventRequest request) throws TException {
        throw new UnsupportedOperationException("fireListenerEvent is not supported.");
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest getPrincRoleReq) throws MetaException, TException {
        throw new UnsupportedOperationException("get_principals_in_role is not supported.");
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest getRolePrincReq) throws MetaException, TException {
        throw new UnsupportedOperationException("get_role_grants_for_principal is not supported.");
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException("getAggrColStatsFor is not supported.");
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        throw new UnsupportedOperationException("setPartitionColumnStatistics is not supported.");
    }

    public void flushCache() {
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        return null;
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        return null;
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        throw new UnsupportedOperationException("clearFileMetadata is not supported.");
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        throw new UnsupportedOperationException("putFileMetadata is not supported.");
    }

    public boolean isSameConfObj(HiveConf c) {
        return false;
    }

    public boolean cacheFileMetadata(String dbName, String tableName, String partName, boolean allParts) throws TException {
        throw new UnsupportedOperationException("cacheFileMetadata is not supported.");
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest request) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getPrimaryKeys is not supported.");
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest request) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("getForeignKeys is not supported.");
    }

    public void createTableWithConstraints(Table tTbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("createTableWithConstraints is not supported.");
    }

    public void dropConstraint(String dbName, String tableName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("dropConstraint is not supported.");
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("addPrimaryKey is not supported.");
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException("addForeignKey is not supported.");
    }
}

