/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.dlc.metastore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.qcloud.dlc.common.Converters;
import com.qcloud.dlc.metastore.IQCloudDLCMetastore;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.dlc.v20210125.DlcClient;
import com.tencentcloudapi.dlc.v20210125.models.AlterDMSTableRequest;
import com.tencentcloudapi.dlc.v20210125.models.Asset;
import com.tencentcloudapi.dlc.v20210125.models.CheckLockMetaDataRequest;
import com.tencentcloudapi.dlc.v20210125.models.CheckLockMetaDataResponse;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSDatabaseRequest;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSDatabaseResponse;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSTableRequest;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSTableResponse;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSTablesRequest;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDMSTablesResponse;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDatabasesRequest;
import com.tencentcloudapi.dlc.v20210125.models.DescribeDatabasesResponse;
import com.tencentcloudapi.dlc.v20210125.models.KVPair;
import com.tencentcloudapi.dlc.v20210125.models.LockComponentInfo;
import com.tencentcloudapi.dlc.v20210125.models.LockMetaDataRequest;
import com.tencentcloudapi.dlc.v20210125.models.LockMetaDataResponse;
import com.tencentcloudapi.dlc.v20210125.models.ReportHeartbeatMetaDataRequest;
import com.tencentcloudapi.dlc.v20210125.models.UnlockMetaDataRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudDLCMetastore
implements IQCloudDLCMetastore {
    private final Configuration conf;
    private final DlcClient dlcClient;
    private final String DLC_DATASOURCE_CONNECTION_DATA_LAKE_CATALOG = "DataLakeCatalog";
    private final String DLC_TABLE_TYPE_EXTERNAL_TABLE = "EXTERNAL_TABLE";
    private int DLC_RETRY_TIMES = 3;
    private static final Logger logger = LoggerFactory.getLogger(QCloudDLCMetastore.class);

    public QCloudDLCMetastore(Configuration conf, DlcClient dlcClient) {
        this.conf = conf;
        this.dlcClient = dlcClient;
    }

    private <R> R proxyCallQCloudClient(Action<R, DlcClient, TencentCloudSDKException> action) throws MetaException {
        R r = null;
        for (int retryTimes = 0; retryTimes < this.DLC_RETRY_TIMES; ++retryTimes) {
            try {
                r = action.run(this.dlcClient);
                break;
            }
            catch (Exception e) {
                logger.error("retry times = {}, with error:", (Object)retryTimes, (Object)e);
                if (retryTimes < this.DLC_RETRY_TIMES) continue;
                throw new MetaException(e.getMessage());
            }
        }
        return r;
    }

    @Override
    public Database getDatabase(String dbName) throws MetaException {
        DescribeDMSDatabaseRequest request = new DescribeDMSDatabaseRequest();
        request.setName(dbName);
        DescribeDMSDatabaseResponse response = this.proxyCallQCloudClient(client -> client.DescribeDMSDatabase(request));
        return Converters.toDatabase(response);
    }

    @Override
    public List<String> getAllDatabases() throws MetaException {
        ArrayList ret = Lists.newArrayList();
        long limit = 100L;
        for (int i = 0; i < 10; ++i) {
            DescribeDatabasesRequest request = new DescribeDatabasesRequest();
            request.setDatasourceConnectionName("DataLakeCatalog");
            request.setLimit(Long.valueOf(limit));
            request.setOffset(Long.valueOf(ret.size()));
            DescribeDatabasesResponse response = this.proxyCallQCloudClient(client -> client.DescribeDatabases(request));
            Arrays.stream(response.getDatabaseList()).forEach(database -> ret.add(database.getDatabaseName()));
            if ((long)ret.size() >= response.getTotalCount()) break;
        }
        return ret;
    }

    @Override
    public Table getTable(String dbName, String tableName) throws MetaException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)dbName), (Object)"database is required.");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)tableName), (Object)"table is required.");
        DescribeDMSTableRequest request = new DescribeDMSTableRequest();
        request.setDbName(dbName);
        request.setName(tableName);
        DescribeDMSTableResponse response = this.proxyCallQCloudClient(client -> client.DescribeDMSTable(request));
        return Converters.toTable(response);
    }

    @Override
    public List<Table> getTables(String dbName, String tablePattern) throws MetaException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)dbName), (Object)"database is required.");
        DescribeDMSTablesRequest request = new DescribeDMSTablesRequest();
        request.setDbName(dbName);
        request.setPattern(tablePattern);
        DescribeDMSTablesResponse response = this.proxyCallQCloudClient(client -> client.DescribeDMSTables(request));
        return ArrayUtils.isEmpty((Object[])response.getTableList()) ? Lists.newArrayList() : Arrays.stream(response.getTableList()).map(Converters::toTable).collect(Collectors.toList());
    }

    @Override
    public void updateTable(String dbName, Table table) throws MetaException {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)dbName), (Object)"database is required.");
        Preconditions.checkNotNull((Object)table, (Object)"table is required.");
        Preconditions.checkArgument((boolean)MapUtils.isNotEmpty((Map)table.getParameters()), (Object)"table property is empty.");
        AlterDMSTableRequest request = new AlterDMSTableRequest();
        request.setDbName(dbName);
        request.setName(table.getTableName());
        request.setCurrentDbName(table.getDbName());
        request.setCurrentName(table.getTableName());
        Map parameters = table.getParameters();
        KVPair[] pairs = (KVPair[])parameters.entrySet().stream().map(entry -> {
            KVPair pair = new KVPair();
            pair.setKey((String)entry.getKey());
            pair.setValue((String)entry.getValue());
            return pair;
        }).toArray(KVPair[]::new);
        Asset asset = new Asset();
        asset.setParams(pairs);
        request.setAsset(asset);
        this.proxyCallQCloudClient(client -> client.AlterDMSTable(request));
    }

    @Override
    public LockResponse lock(LockRequest req) throws MetaException {
        LockMetaDataRequest request = new LockMetaDataRequest();
        request.setTxnId(Long.valueOf(req.getTxnid()));
        request.setDatasourceConnectionName("DataLakeCatalog");
        request.setHostname(req.getHostname());
        request.setAgentInfo(req.getAgentInfo());
        List lockComponents = req.getComponent();
        ArrayList<LockComponentInfo> lockComponentInfos = new ArrayList<LockComponentInfo>();
        for (int i = 0; i < req.getComponentSize(); ++i) {
            LockComponent lockComponent = (LockComponent)lockComponents.get(i);
            LockComponentInfo lockComponentInfo = new LockComponentInfo();
            lockComponentInfo.setDbName(lockComponent.getDbname());
            lockComponentInfo.setTableName(lockComponent.getTablename());
            lockComponentInfo.setPartition(lockComponent.getPartitionname());
            lockComponentInfo.setLockType(lockComponent.getType().name());
            lockComponentInfo.setLockLevel(lockComponent.getLevel().name());
            lockComponentInfo.setDataOperationType(lockComponent.getOperationType().name());
            lockComponentInfo.setIsAcid(Boolean.valueOf(lockComponent.isIsAcid()));
            lockComponentInfo.setIsDynamicPartitionWrite(Boolean.valueOf(lockComponent.isIsDynamicPartitionWrite()));
            lockComponentInfos.add(lockComponentInfo);
        }
        request.setLockComponentList(lockComponentInfos.toArray(new LockComponentInfo[0]));
        LockMetaDataResponse response = this.proxyCallQCloudClient(client -> client.LockMetaData(request));
        LockResponse lockResponse = new LockResponse();
        lockResponse.setLockid(response.getLockId().longValue());
        lockResponse.setState(LockState.valueOf((String)response.getLockState()));
        return lockResponse;
    }

    @Override
    public LockResponse checkLock(Long lockId) throws MetaException {
        CheckLockMetaDataRequest request = new CheckLockMetaDataRequest();
        request.setLockId(lockId);
        CheckLockMetaDataResponse response = this.proxyCallQCloudClient(client -> client.CheckLockMetaData(request));
        LockResponse lockResponse = new LockResponse();
        lockResponse.setLockid(response.getLockId().longValue());
        lockResponse.setState(LockState.valueOf((String)response.getLockState()));
        return lockResponse;
    }

    @Override
    public void unlock(Long lockId) throws MetaException {
        UnlockMetaDataRequest request = new UnlockMetaDataRequest();
        request.setDatasourceConnectionName("DataLakeCatalog");
        request.setLockId(lockId);
        this.proxyCallQCloudClient(client -> client.UnlockMetaData(request));
    }

    @Override
    public void heartbeat(Long txnId, Long lockId) throws MetaException {
        ReportHeartbeatMetaDataRequest request = new ReportHeartbeatMetaDataRequest();
        request.setDatasourceConnectionName("DataLakeCatalog");
        request.setTxnId(txnId);
        request.setLockId(lockId);
        this.proxyCallQCloudClient(client -> client.ReportHeartbeatMetaData(request));
    }

    static interface Action<R, C, E extends Exception> {
        public R run(C var1) throws E;
    }
}

