package com.tencent.cloud.dlc.jdbc;

import com.tencent.cloud.dlc.jdbc.utils.TaskUtils;
import com.tencentcloudapi.dlc.v20210125.models.KVPair;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.*;
import java.util.stream.Collectors;

public class ConnectionResource {

  public static final String SECRET_ID_PROP_KEY = "user";
  public static final String SECRET_KEY_PROP_KEY = "password";
  public static final String SECRET_ID_URL_KEY = "secret_id";
  public static final String SECRET_KEY_URL_KEY = "secret_key";
  public static final String TOKEN_URL_KEY = "token";
  public static final String SUBUIN_URL_KEY = "sub_uin";
  public static final String SUBUIN_PROP_KEY = "sub_uin";
  public static final String TOKEN_PROP_KEY = "token";
  public static final String TASK_TYPE_PROP_KEY = "task_type";
  public static final String RESULT_TYPE_PROP_KEY = "result_type";
  public static final String DATABASE_NAME_PROP_KEY = "database_name";
  public static final String DATABASE_NAME_URL_KEY = "database_name";
  public static final String DATASOURCE_CONNECTION_NAME_PROP_KEY = "datasource_connection_name";
  public static final String DATASOURCE_CONNECTION_NAME_URL_KEY = "datasource_connection_name";
  private static final String DATA_ENGINE_NAME_PROP_KEY = "data_engine_name";
  private static final String DATA_ENGINE_NAME_URL_KEY = "data_engine_name";


  public static final String REGION_PROP_KEY = "region";
  public static final String LOG_CONF_FILE_PROP_KEY = "log_conf_file";
  public static final String ENABLE_DLC_LOGGER_PROP_KEY = "enable_dlc_logger";
  public static final String MAJOR_VERSION_PROP_KEY = "major_version";
  private static final String SECRET_ID_PROP_KEY_ALIAS = "secret_id";
  private static final String SECRET_KEY_PROP_KEY_ALIAS = "secret_key";
  private static final String JDBC_DLC_URL_PREFIX = "jdbc:dlc:";
  private static final String JDBC_DLC_URL_PREFIX_NEW = "jdbc:dlc://";
  private static final String DLC_CONF_URL_KEY = "dlc_config";

  private static final String TASK_TYPE_URL_KEY = "task_type";
  private static final String RESULT_TYPE_URL_KEY = "result_type";
  private static final String REGION_URL_KEY = "region";
  private static final String LOG_CONF_FILE_URL_KEY = "log_conf_file";
  private static final String ENABLE_DLC_LOGGER_URL_KEY = "enable_dlc_logger";
  private static final String MAJOR_VERSION_URL_KEY = "major_version";

  private static final String CHARSET_DEFAULT_VALUE = "UTF-8";
  private static final String CHARSET_KEY = "charset";

  private String endpoint;
  private String secretId;
  private String secretKey;
  private String token;
  private String subUin;
  private String taskType;
  private String resultType;
  private String region;
  private String databaseName;
  private String datasourceConnectionName;
  private String dataEngineName;
  private KVPair[] engineConfig ;


  private String logConfFile;
  private boolean enableDlcLogger = false;
  private String majorVersion;
  private boolean disableConnSetting = false;
  private String charset;

  public ConnectionResource(String url, Properties info) {
    Map<String, String> paramsInURL = extractParamsFromUrl(url);
    init(info, paramsInURL);
  }

  public static boolean acceptURL(String url) {
    return (url != null) && url.startsWith(JDBC_DLC_URL_PREFIX);
  }

  @SuppressWarnings("rawtypes")
  private static String tryGetFirstNonNullValueByAltMapAndAltKey(
          List<Map> maps, String defaultValue, String... altKeys) {
    String value = null;
    for (Map map : maps) {
      if (map != null) {
        for (String key : altKeys) {
          if ((value = (String) map.get(key)) != null) {
            return value;
          }
        }
      }
    }
    return defaultValue;
  }

  private static KVPair[] tryGetFirstNonNullValueByPrefixKey(
          List<Map> maps, String... prefixs) {
    List<KVPair> configList =new ArrayList<>();
    List<String> sysConfigs = Arrays.stream(prefixs).collect(Collectors.toList());
    for (Map map : maps) {
      if (map != null) {
        List<String> configs = (List<String>) map.keySet().stream().filter(p -> !sysConfigs.contains(p)).collect(Collectors.toList());
        for (String config: configs){
          KVPair pair =new KVPair();
          pair.setKey(config);
          pair.setValue((String) map.get(config));
          configList.add(pair);
        }
      }
    }
    return configList.toArray(new KVPair[configList.size()]);
  }

  @SuppressWarnings("rawtypes")
  void init(Properties info, Map<String, String> paramsInURL) {
    List<Map> maps = new ArrayList<Map>();
    if (paramsInURL.get(DLC_CONF_URL_KEY) != null) {
      try {
        InputStream inputStream = new FileInputStream(paramsInURL.get(DLC_CONF_URL_KEY));
        if (inputStream != null) {
          Properties props = new Properties();
          props.load(inputStream);
          maps.add(props);
        }
      } catch (IOException e) {
        throw new RuntimeException("Load dlc conf failed:", e);
      }
    } else {
      maps.add(info);
      maps.add(paramsInURL);
    }

    secretId = tryGetFirstNonNullValueByAltMapAndAltKey(
            maps, null, SECRET_ID_PROP_KEY_ALIAS, SECRET_ID_PROP_KEY, SECRET_ID_URL_KEY);
    secretKey = tryGetFirstNonNullValueByAltMapAndAltKey(
            maps, null, SECRET_KEY_PROP_KEY_ALIAS, SECRET_KEY_PROP_KEY, SECRET_KEY_URL_KEY);
    token = tryGetFirstNonNullValueByAltMapAndAltKey(
            maps, "", TOKEN_URL_KEY,TOKEN_PROP_KEY);
    subUin = tryGetFirstNonNullValueByAltMapAndAltKey(
            maps, null, SUBUIN_PROP_KEY, SUBUIN_URL_KEY);
    taskType = tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, TASK_TYPE_PROP_KEY, TASK_TYPE_URL_KEY);
    resultType = tryGetFirstNonNullValueByAltMapAndAltKey(maps, TaskUtils.ResultType.Service.name(), RESULT_TYPE_PROP_KEY, RESULT_TYPE_URL_KEY);
    region = tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, REGION_PROP_KEY, REGION_URL_KEY);

    logConfFile = tryGetFirstNonNullValueByAltMapAndAltKey(
            maps, null, LOG_CONF_FILE_PROP_KEY, LOG_CONF_FILE_URL_KEY);
    enableDlcLogger =
            Boolean.valueOf(tryGetFirstNonNullValueByAltMapAndAltKey(
                    maps, "false", ENABLE_DLC_LOGGER_PROP_KEY, ENABLE_DLC_LOGGER_URL_KEY));
    majorVersion = tryGetFirstNonNullValueByAltMapAndAltKey(
            maps, null, MAJOR_VERSION_PROP_KEY, MAJOR_VERSION_URL_KEY);
    charset = tryGetFirstNonNullValueByAltMapAndAltKey(maps, CHARSET_DEFAULT_VALUE, CHARSET_KEY);
    databaseName = tryGetFirstNonNullValueByAltMapAndAltKey(maps, null, DATABASE_NAME_PROP_KEY, DATABASE_NAME_URL_KEY);
    datasourceConnectionName = tryGetFirstNonNullValueByAltMapAndAltKey(maps, "",
            DATASOURCE_CONNECTION_NAME_PROP_KEY, DATASOURCE_CONNECTION_NAME_URL_KEY);
    dataEngineName = tryGetFirstNonNullValueByAltMapAndAltKey(maps, "",
            DATA_ENGINE_NAME_PROP_KEY, DATA_ENGINE_NAME_URL_KEY);
    engineConfig = tryGetFirstNonNullValueByPrefixKey(maps,SECRET_ID_PROP_KEY,SECRET_ID_PROP_KEY_ALIAS,
            SECRET_KEY_PROP_KEY_ALIAS,SECRET_KEY_PROP_KEY,TOKEN_URL_KEY,TASK_TYPE_PROP_KEY,
            RESULT_TYPE_PROP_KEY,REGION_PROP_KEY,LOG_CONF_FILE_PROP_KEY,ENABLE_DLC_LOGGER_PROP_KEY,
            MAJOR_VERSION_PROP_KEY,CHARSET_DEFAULT_VALUE,DATABASE_NAME_PROP_KEY,
            DATASOURCE_CONNECTION_NAME_PROP_KEY,DATA_ENGINE_NAME_PROP_KEY);

  }

  private Map<String, String> extractParamsFromUrl(String url) {
    Map<String, String> paramsInURL = new HashMap<String, String>();
    if (url.contains(JDBC_DLC_URL_PREFIX_NEW)) {
      url = url.substring(JDBC_DLC_URL_PREFIX_NEW.length());
    } else {
      url = url.substring(JDBC_DLC_URL_PREFIX.length());
    }
    int atPos = url.indexOf("?");
    if (atPos == -1) {
      endpoint = url;
    } else {
      endpoint = url.substring(0, atPos);
      int atPos1 = endpoint.indexOf(":");
      if (atPos1 != -1) {
         endpoint = endpoint.substring(0,atPos1);
      }
      String query = url.substring(atPos + 1);
      String[] pairs = query.split("&");

      for (String pair : pairs) {
        int pos = pair.indexOf("=");
        if (pos > 0) {
          paramsInURL.put(
                  URLDecoder.decode(pair.substring(0, pos)),
                  URLDecoder.decode(pair.substring(pos + 1)));
        } else {
          paramsInURL.put(URLDecoder.decode(pair), null);
        }
      }
    }
    return paramsInURL;
  }

  public String getEndpoint() {
    return endpoint;
  }

  public String getSecretId() {
    return secretId;
  }

  public String getSecretKey() {
    return secretKey;
  }

  public String getToken() {
    return token;
  }

  public String getSubUin() {
    return subUin;
  }

  public String getTaskType() {
    return taskType;
  }

  public String getRegion() {
    return region;
  }

  public String getLogConfFile() {
    return logConfFile;
  }

  public boolean isEnableDlcLogger() {
    return enableDlcLogger;
  }

  public String getMajorVersion() {
    return majorVersion;
  }

  public boolean isDisableConnSetting() {
    return disableConnSetting;
  }

  public String getCharset() {
    return charset;
  }

  public String getDatabaseName() {
    return databaseName;
  }

  public void setDatabaseName(String databaseName) {
    this.databaseName = databaseName;
  }

  public String getDatasourceConnectionName() {
    return datasourceConnectionName;
  }

  public void setDatasourceConnectionName(String datasourceConnectionName) {
    this.datasourceConnectionName = datasourceConnectionName;
  }

  public void setDataEngineName(String dataEngineName) {
    this.dataEngineName = dataEngineName;
  }

  public String getDataEngineName() { return dataEngineName; }

  public String getResultType() {
    return resultType;
  }

  public void setResultType(String resultType) {
    this.resultType = resultType;
  }

  public KVPair[] getEngineConfig() {
    return engineConfig;
  }

  public void setEngineConfig(KVPair[] engineConfig) {
    this.engineConfig = engineConfig;
  }
}
