package com.tencent.cloud.dlc.jdbc;

import java.sql.*;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.tencent.cloud.dlc.jdbc.utils.Utils;

public class DlcDriver implements Driver {

  static {
    try {
      DriverManager.registerDriver(new DlcDriver());
    }
    catch (SQLException e) {
      Logger.getLogger(DlcDriver.class.getPackage().getName())
          .log(Level.SEVERE, "Failed to register driver", e);
      throw new RuntimeException(e);
    }
  }

  private static final boolean JDBC_COMPLIANT = false;


  public DlcDriver() {
    SecurityManager security = System.getSecurityManager();
    if (security != null) {
      security.checkWrite("dlc");
    }
  }


  @Override
  public Connection connect(String url, Properties info) throws SQLException {
    return acceptsURL(url) ? new DlcConnection(url, info) : null;
  }

  @Override
  public boolean acceptsURL(String url) throws SQLException {
    return ConnectionResource.acceptURL(url);
  }

  @Override
  public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
    ConnectionResource connRes = new ConnectionResource(url, info);

    DriverPropertyInfo secretIdProp =
        new DriverPropertyInfo(ConnectionResource.SECRET_ID_PROP_KEY, connRes.getSecretId());
    secretIdProp.required = true;
    secretIdProp.description = "secret id";

    DriverPropertyInfo secretKeyProp =
        new DriverPropertyInfo(ConnectionResource.SECRET_KEY_PROP_KEY, connRes.getSecretKey());
    secretKeyProp.required = true;
    secretKeyProp.description = "secret key";

    DriverPropertyInfo taskTypeProp =
        new DriverPropertyInfo(ConnectionResource.TASK_TYPE_PROP_KEY, connRes.getTaskType());
    taskTypeProp.required = true;
    taskTypeProp.description = "DLC task type, such as SQLTask, SparkSQLTask";

    DriverPropertyInfo regionProp =
        new DriverPropertyInfo(ConnectionResource.REGION_PROP_KEY, connRes.getRegion());
    regionProp.required = true;
    regionProp.description = "region";

    return new DriverPropertyInfo[]{secretIdProp, secretKeyProp, taskTypeProp, regionProp};
  }

  @Override
  public int getMajorVersion() {
    try {
      return Integer.parseInt(Utils.retrieveVersion("driver.version").split("\\.")[0]);
    } catch (Exception e) {
      e.printStackTrace();
      return 1;
    }
  }

  @Override
  public int getMinorVersion() {
    try {
      return Integer.parseInt(Utils.retrieveVersion("driver.version").split("\\.")[1]);
    } catch (Exception e) {
      e.printStackTrace();
      return 0;
    }
  }

  @Override
  public boolean jdbcCompliant() {
    return false;
  }

  @Override
  public Logger getParentLogger() throws SQLFeatureNotSupportedException {
    return Logger.getLogger("com.tencent.cloud.dlc.jdbc");
  }
}
