package com.tencent.cloud.dlc.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

class DlcStaticResultSet extends DlcResultSet implements ResultSet {

  Object[] row;
  private Iterator<Object[]> iterator;
  private boolean isClosed = false;
  /**
   * For some meta query (like procedures) we need to return an empty query result.
   */
  private boolean isEmptyResultSet = false;

  DlcStaticResultSet(DlcConnection conn, DlcResultSetMetaData meta) throws SQLException {
    super(conn, null, meta);
    // Construct an empty result set
    isEmptyResultSet = true;
  }

  /**
   * For non-empty result set, its data is passed via parameter
   */
  DlcStaticResultSet(DlcConnection conn, DlcResultSetMetaData meta, Iterator<Object[]> iter)
          throws SQLException {
    super(conn, null, meta);
    iterator = iter;
    isEmptyResultSet = false;
  }

  @Override
  public void close() throws SQLException {
    iterator = null;
    isClosed = true;
  }

  @Override
  public boolean isClosed() {
    return isClosed;
  }

  @Override
  public boolean next() throws SQLException {
    if (isEmptyResultSet) {
      return false;
    }
    if (iterator.hasNext()) {
      row = iterator.next();
      return true;
    } else {
      return false;
    }
  }

  @Override
  protected Object[] rowAtCursor() throws SQLException {
    return row;
  }
}