package com.tencent.cloud.dlc.jdbc;

import java.sql.SQLException;
import java.sql.Wrapper;

public class WrapperAdapter implements Wrapper {

  @SuppressWarnings("unchecked")
  @Override
  public <T> T unwrap(Class<T> iface) throws SQLException {
    if (iface == null) {
      return null;
    }

    if (iface.isInstance(this)) {
      return (T) this;
    }

    return null;
  }

  @Override
  public boolean isWrapperFor(Class<?> iface) throws SQLException {
    return iface != null && iface.isInstance(this);
  }
}
