package com.tencent.cloud.dlc.jdbc.client;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.dlc.v20210125.DlcClient;

public class Dlc {

  private DlcClient client;
  private Account account;
  private String region;
  private String endpoint;

  public Dlc(Account account, String region, String endpoint) {
    // 实例化一个认证对象，入参需要传入腾讯云账户secretId，secretKey,此处还需注意密钥对的保密
    // 密钥可前往https://console.cloud.tencent.com/cam/capi网站进行获取
    Credential cred = new Credential(account.getSecretId(), account.getSecretKey(), account.getToken());

    // 实例化一个http选项，可选的，没有特殊需求可以跳过
    HttpProfile httpProfile = new HttpProfile();
    // 默认值 dlc.tencentcloudapi.com
    httpProfile.setEndpoint(endpoint);
    // 实例化一个client选项，可选的，没有特殊需求可以跳过
    ClientProfile clientProfile = new ClientProfile();
    clientProfile.setHttpProfile(httpProfile);
    // 实例化要请求产品的client对象,clientProfile是可选的
    this.client = new DlcClient(cred, region, clientProfile);
    this.account = account;
    this.region = region;
    this.endpoint = endpoint;
  }

  public DlcClient getClient() {
    return client;
  }

  public Account getAccount() {
    return account;
  }

  public void setAccount(Account account) {
    this.account = account;
  }

  public String getRegion() {
    return region;
  }

  public void setRegion(String region) {
    this.region = region;
  }

  public String getEndpoint() {
    return endpoint;
  }

  public void setEndpoint(String endpoint) {
    this.endpoint = endpoint;
  }
}
