package com.tencent.cloud.dlc.jdbc.cos;

import com.tencent.cloud.dlc.jdbc.cos.ColumnInfo;
import com.tencentcloudapi.dlc.v20210125.models.Column;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class COSResultMeta {
    private String taskId;
    private ColumnInfo[] columns;

    public COSResultMeta(String taskId, ColumnInfo[] columns) {
        this.taskId = taskId;
        this.columns = columns;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public Column[] getColumns() {
      List<Column> columnList = Arrays.stream(columns).map(this::convertToColumn).collect(Collectors.toList());
      Column[] columnArray = new Column[columnList.size()];
      columnList.toArray(columnArray);
      return columnArray;
    }

    public void setColumns(ColumnInfo[] columns) {
        this.columns = columns;
    }

    public Column convertToColumn(ColumnInfo columnInfo){
           Column column = new Column();
           column.setName(columnInfo.getName());
           column.setScale(columnInfo.getScale());
           column.setType(columnInfo.getType());
           column.setPrecision(columnInfo.getPrecision());
           column.setPosition(columnInfo.getPosition());
           column.setComment(columnInfo.getComment());
           column.setNullable(columnInfo.getNullable());
           return column;
    }

}
