package com.tencent.cloud.dlc.jdbc.utils;

import java.sql.Timestamp;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class DlcFormatter extends Formatter {

  @Override
  public synchronized String format(LogRecord record) {
    Timestamp timestamp = new Timestamp(record.getMillis());
    String format = "[%s] [connection-%s] [%s] %s\n";
    return String.format(
        format,
        record.getLevel(),
        record.getLoggerName(),
        timestamp.toString(),
        record.getMessage());
  }
}
