package com.tencent.cloud.dlc.jdbc.utils;


import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public final class IoUtils {
    private static final int BUFFER_SIZE = 4096;
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(IoUtils.class);

    private IoUtils() {
    }

    public static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Throwable var2 = null;

        try {
            byte[] b = new byte[4096];
            boolean var4 = false;

            int n;
            while((n = is.read(b)) != -1) {
                output.write(b, 0, n);
            }

            byte[] var5 = output.toByteArray();
            return var5;
        } catch (Throwable var14) {
            var2 = var14;
            throw var14;
        } finally {
            if (output != null) {
                if (var2 != null) {
                    try {
                        output.close();
                    } catch (Throwable var13) {
                        var2.addSuppressed(var13);
                    }
                } else {
                    output.close();
                }
            }

        }
    }

    public static String toUtf8String(InputStream is) throws IOException {
        return new String(toByteArray(is), StandardCharsets.UTF_8);
    }

    public static void closeQuietly(AutoCloseable is, Logger log) {
        if (is != null) {
            try {
                is.close();
            } catch (Exception var4) {
                Logger logger = log == null ? DEFAULT_LOG : log;
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignore failure in closing the Closeable", var4);
                }
            }
        }

    }

    public static void closeIfCloseable(Object maybeCloseable, Logger log) {
        if (maybeCloseable instanceof AutoCloseable) {
            closeQuietly((AutoCloseable)maybeCloseable, log);
        }

    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return copy(in, out, 9223372036854775807L);
    }

    public static long copy(InputStream in, OutputStream out, long readLimit) throws IOException {
        byte[] buf = new byte[4096];
        long count = 0L;
        boolean var7 = false;

        do {
            int n;
            if ((n = in.read(buf)) <= -1) {
                return count;
            }

            out.write(buf, 0, n);
            count += (long)n;
        } while(count < readLimit);

        throw new IOException("Read limit exceeded: " + readLimit);
    }

    public static void drainInputStream(InputStream in) {
        while(true) {
            try {
                if (in.read() != -1) {
                    continue;
                }
            } catch (IOException var2) {
            }

            return;
        }
    }

    public static void markStreamWithMaxReadLimit(InputStream s) {
        if (s.markSupported()) {
            s.mark(131072);
        }

    }
}

