/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package com.tencent.cloud.dlc.jdbc.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.slf4j.Logger;

public class LoggerFactory {

  private static Map<String, Logger> cache = new ConcurrentHashMap<String, Logger>();

  @SuppressWarnings({"rawtypes", "unchecked"})
  public static Logger getLogger(String logConfFile, String name) {
    if (cache.containsKey(name)) {
      return cache.get(name);
    }
    Logger logger = null;
    if (logConfFile != null) {
      try {
        Class loggerContextClazz = Class.forName("ch.qos.logback.classic.LoggerContext");
        Class contextInitializerClazz =
            Class.forName("ch.qos.logback.classic.util.ContextInitializer");
        Object loggerContext = loggerContextClazz.newInstance();
        Object contextInitializer =
            contextInitializerClazz.getConstructor(loggerContextClazz).newInstance(loggerContext);
        Method configureByResourceMethod =
            contextInitializerClazz.getMethod("configureByResource", URL.class);
        URL url = new File(logConfFile).toURI().toURL();
        configureByResourceMethod.invoke(contextInitializer, url);
        Method getLoggerMethod = loggerContextClazz.getMethod("getLogger", String.class);
        logger = (Logger) getLoggerMethod.invoke(loggerContext, name);
        logger.debug("Configure logConf Successfully : {}", url);
      } catch (Throwable e) {
        org.slf4j.LoggerFactory.getLogger(name).error(
            "Configure logConf failed: " + logConfFile
                + " , replace with application's default conf ~ ", e);
        logger = org.slf4j.LoggerFactory.getLogger(name);
      }
    } else {
      logger = org.slf4j.LoggerFactory.getLogger(name);
    }
    cache.put(name, logger);
    return logger;
  }

}
