/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */

package com.tencent.cloud.dlc.jdbc.utils.to.transformer.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;
import java.util.TimeZone;


public class ToJdbcTimeTransfomer extends AbstractToJdbcDateTypeTransformer {


  @Override
  public Object transform(
      String o) throws SQLException {
    if (o == null) {
      return null;
    } else {
      try {
        LocalTime time = TIME_FORMAT.parse(o, TemporalQueries.localTime());
        ZoneId zone = TIME_FORMAT.parse(o, TemporalQueries.zone());
        if (zone != null) {
          time = LocalDateTime
                  .of(LocalDate.now(), time)
                  .atZone(zone)
                  .withZoneSameInstant(ZoneId.systemDefault())
                  .toLocalTime();
        }
        return Time.valueOf(time);
      } catch (DateTimeParseException dtpe) {
        throw new SQLDataException(String.format("Could not convert \"%s\" to Time", o), dtpe);
      }
    }

  }
}
