/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */

package com.tencent.cloud.dlc.jdbc.utils.to.transformer.jdbc;

import org.bouncycastle.math.ec.ScaleYNegateXPointMap;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;


public class ToJdbcTimestampTransformer extends AbstractToJdbcDateTypeTransformer {

  @Override
  public Object transform(
      String o) throws SQLException {

    if (o == null) {
      return null;
    } else {
      try {
        TemporalAccessor parsedTimestamp = TIMESTAMP_FORMAT.parseBest(o, ZonedDateTime::from, LocalDateTime::from);
        ZonedDateTime zonedTimestamp;
        if (parsedTimestamp instanceof ZonedDateTime) {
          zonedTimestamp = (ZonedDateTime) parsedTimestamp;
        } else {
          zonedTimestamp = ((LocalDateTime) parsedTimestamp).atZone(ZoneId.systemDefault());
        }
        return new Timestamp(zonedTimestamp.toInstant().toEpochMilli());
      } catch (DateTimeParseException e) {
        throw new SQLDataException(String.format("Could not convert \"%s\" to Timestamp", o), e);
      }
    }


  }

  public static void main(String[] args) throws SQLException {
    System.out.println(new ToJdbcTimestampTransformer().transform("2022-06-15T10:04:57.000+08:00"));
  }
}
