CREATE TABLE [ IF NOT EXISTS ] table_identifier
[ ( col_name1 col_type1 [ COMMENT col_comment1 ], ... ) ]
USING hudi [ OPTIONS ( key1=val1, key2=val2, ... ) ]
[ PARTITIONED BY ( col_name1, col_name2, ... ) ]
[ COMMENT table_comment ] [ TBLPROPERTIES ( key1=val1, key2=val2, ... ) ]
[ AS select_statement ]

-- 创建hudi分区表，设置Partition，加速数据查询速度
create table hudi_cow_pt_tbl (
  id bigint,
  name string,
  ts bigint,
  dt string,
  hh string
) using hudi
tblproperties (
  type = 'cow',
  primaryKey = 'id',
  preCombineField = 'ts'
 )
partitioned by (dt, hh)

-- 基于现有的数据创建hudi表，需要进行数据迁移，如，从Hive表复制到hudi表时，可以使用
CREATE TABLE db.student_copy USING hudi AS SELECT * FROM db.student;

DROP TABLE [IF EXISTS] <db_name>.<table_name> [PURGE]

ALTER TABLE <table_name> RENAME TO <new_table_name>

ALTER TABLE <table_name> ADD COLUMNS ( col_spec [ , ... ] )

ALTER TABLE <table_name> { ALTER | CHANGE } [ COLUMN ] col_spec alterColumnAction

alter table hudi_cow_nonpcf_tbl2 set tblproperties (hoodie.keep.max.commits = '10');

TRUNCATE TABLE <table_name>;

ALTER TABLE <table_name> DROP [ IF EXISTS ] partition_spec [PURGE]

- 按value值插入
INSERT INTO db.table VALUES (1, 'a'), (2, 'b')
-- 插入分区
INSERT INTO db.table partition(dt = '2021-01-05') SELECT 2 as id, 'a2' as name, 10 as price, 1000 as ts
-- 无分区数据插入
INSERT INTO db.table SELECT 2 as id, 'a2' as name, 10 as price, 1000 as ts

insert overwrite table db.table select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-01-05' as dt

UPDATE tableIdentifier SET column = EXPRESSION(,column = EXPRESSION) [ WHERE boolExpression]

MERGE INTO tableIdentifier AS target_alias
USING (sub_query | tableIdentifier) AS source_alias
ON <merge_condition>
[ WHEN MATCHED [ AND <condition> ] THEN <matched_action> ]
[ WHEN MATCHED [ AND <condition> ] THEN <matched_action> ]
[ WHEN NOT MATCHED [ AND <condition> ]  THEN <not_matched_action> ]

<merge_condition> =A equal bool condition
<matched_action>  =
  DELETE  |
  UPDATE SET *  |
  UPDATE SET column1 = expression1 [, column2 = expression2 ...]
<not_matched_action>  =
  INSERT *  |
  INSERT (column1 [, column2 ...]) VALUES (value1 [, value2 ...])

  CALL system.procedure_name(arg_name_2 => arg_2, arg_name_1 => arg_1, ... arg_name_n => arg_n)

  CALL system.procedure_name(arg_1, arg_2, ... arg_n)

  call show_commits(table => 'test_hudi_table', limit => 10);

1. 从 Hudi 0.10.0版本之后， `primaryKey` 是必需的。
2. 与 类似 `hoodie.datasource.write.recordkey.field` ， `uuid` 默认用作主键；如果您的桌子是这种情况，您可以跳过设置 `primaryKey` 。 `tblproperties`
3. `primaryKey` ,  `preCombineField` , 和 `type` 区分大小写。
4. MOR 表需要设置`preCombineField`。
5. 当设置 `primaryKey` ,或其他 Hudi 配置时， `preCombineField` 优先于. `type`  `tblproperties`  `options`
6. 由 Spark SQL 创建的新 Hudi 表将默认设置 `hoodie.table.keygenerator.class=org.apache.hudi.keygen.ComplexKeyGenerator` 和  `hoodie.datasource.write.hive_style_partitioning=true` .

-- 查询数据库oms下的hudi_user_cow_nickhliu数据表
select * from oms.hudi_user_cow_nickhliu where id = 1;

-- 查询数据库oms下的hudi_user_mor_nickhliu数据表
-- 快照查询
select * from oms.hudi_user_mor_nickhliu_rt where id = 1;

-- 读优化查询
select * from oms.hudi_user_mor_nickhliu_ro where id = 1;











