/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.request.AbstractBaseRequest;
import java.io.File;

public class FaceDetectRequest
extends AbstractBaseRequest {
    private boolean isUrl = true;
    private int mode = 0;
    private String url = "";
    private File image;

    public FaceDetectRequest(String bucketName, String url, int mode) {
        super(bucketName);
        this.isUrl = true;
        this.mode = mode;
        this.url = url;
    }

    public FaceDetectRequest(String bucketName, String name, File image, int mode) {
        super(bucketName);
        this.isUrl = false;
        this.mode = mode;
        this.image = image;
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public int getMode() {
        return this.mode;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public File getImage() {
        return this.image;
    }

    public void setImage(File image) {
        this.image = image;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        if (this.isUrl) {
            CommonParamCheckUtils.AssertNotNull("url", this.url);
        } else {
            CommonParamCheckUtils.AssertNotNull("image content", this.image);
        }
        if (this.mode != 0 && this.mode != 1) {
            throw new ParamException("param mode error, please check!");
        }
    }
}

