/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.ClientConfig;
import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.request.AbstractBaseRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class IdcardDetectRequest
extends AbstractBaseRequest {
    private boolean isUrl = true;
    private int cardType = 0;
    private ArrayList<String> urlList = new ArrayList();
    private HashMap<String, String> keyList = new HashMap();
    private HashMap<String, File> imageList = new HashMap();

    public IdcardDetectRequest(String bucketName, String[] urlList, int cardType) {
        super(bucketName);
        this.isUrl = true;
        this.cardType = cardType;
        for (int i = 0; i < urlList.length; ++i) {
            this.urlList.add(urlList[i]);
        }
    }

    public IdcardDetectRequest(String bucketName, File[] image, int cardType) {
        super(bucketName);
        this.isUrl = false;
        this.cardType = cardType;
        for (int i = 0; i < image.length; ++i) {
            this.imageList.put(i + "", image[i]);
            this.keyList.put(i + "", String.format("image[%d]", i));
        }
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public ArrayList<String> getUrlList() {
        return this.urlList;
    }

    public int getCardType() {
        return this.cardType;
    }

    public HashMap<String, String> getKeyList() {
        return this.keyList;
    }

    public void setUrlList(ArrayList<String> urlList) {
        this.urlList = urlList;
    }

    public HashMap<String, File> getImageList() {
        return this.imageList;
    }

    public void setImageList(HashMap<String, File> imageList) {
        this.imageList = imageList;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        if (this.isUrl) {
            CommonParamCheckUtils.AssertNotZero("url list", this.urlList.size());
            CommonParamCheckUtils.AssertExceed("url list", this.urlList.size(), ClientConfig.getMaxDetectionNum());
        } else {
            CommonParamCheckUtils.AssertNotZero("image list", this.imageList.size());
            CommonParamCheckUtils.AssertExceed("image list", this.imageList.size(), ClientConfig.getMaxDetectionNum());
        }
        if (this.cardType != 0 && this.cardType != 1) {
            throw new ParamException("param cardType error, please check!");
        }
    }
}

