/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.ClientConfig;
import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.request.AbstractBaseRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class PornDetectRequest
extends AbstractBaseRequest {
    private boolean isUrl;
    private HashMap<String, String> keyList = new HashMap();
    private ArrayList<String> urlList = new ArrayList();
    private HashMap<String, File> imageList = new HashMap();

    public PornDetectRequest(String bucketName, String[] urlList) {
        super(bucketName);
        this.isUrl = true;
        for (int i = 0; i < urlList.length; ++i) {
            this.urlList.add(urlList[i]);
        }
    }

    public PornDetectRequest(String bucketName, File ... image) {
        super(bucketName);
        this.isUrl = false;
        for (int i = 0; i < image.length; ++i) {
            String key = i + "";
            this.imageList.put(key, image[i]);
            this.keyList.put(key, String.format("image[%d]", i));
        }
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public ArrayList<String> getUrlList() {
        return this.urlList;
    }

    public HashMap<String, String> getKeyList() {
        return this.keyList;
    }

    public void setUrlList(ArrayList<String> urlList) {
        this.urlList = urlList;
    }

    public HashMap<String, File> getImageList() {
        return this.imageList;
    }

    public void setImageList(HashMap<String, File> imageList) {
        this.imageList = imageList;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        if (this.isUrl) {
            CommonParamCheckUtils.AssertNotZero("url list", this.urlList.size());
            CommonParamCheckUtils.AssertExceed("url list", this.urlList.size(), ClientConfig.getMaxDetectionNum());
        } else {
            CommonParamCheckUtils.AssertNotZero("image list", this.imageList.size());
            CommonParamCheckUtils.AssertExceed("image list", this.imageList.size(), ClientConfig.getMaxDetectionNum());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.isUrl) {
            sb.append(", [");
            for (String url : this.urlList) {
                sb.append(url).append(", ");
            }
            sb.append("]");
        } else {
            sb.append(", [");
            for (String name : this.imageList.keySet()) {
                sb.append(name).append(", ");
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

