/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.Module;

import com.qcloud.Common.Request;
import java.util.TreeMap;

public abstract class Base {
    protected String serverHost = "";
    protected String serverUri = "/v2/index.php";
    protected String secretId = "";
    protected String secretKey = "";
    protected String defaultRegion = "";
    protected String requestMethod = "GET";

    public void setConfig(TreeMap<String, Object> config) {
        if (config == null) {
            return;
        }
        for (String key : config.keySet()) {
            if (key.equals("SecretId")) {
                this.setConfigSecretId(config.get(key).toString());
                continue;
            }
            if (key.equals("SecretKey")) {
                this.setConfigSecretKey(config.get(key).toString());
                continue;
            }
            if (key.equals("DefaultRegion")) {
                this.setConfigDefaultRegion(config.get(key).toString());
                continue;
            }
            if (!key.equals("RequestMethod")) continue;
            this.setConfigRequestMethod(config.get(key).toString());
        }
    }

    public void setConfigSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setConfigSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setConfigDefaultRegion(String region) {
        this.defaultRegion = region;
    }

    public void setConfigRequestMethod(String method) {
        this.requestMethod = method;
    }

    public String getLastRequest() {
        return Request.getRequestUrl();
    }

    public String getLastResponse() {
        return Request.getRawResponse();
    }

    private String ucFirst(String word) {
        return word.replaceFirst(word.substring(0, 1), word.substring(0, 1).toUpperCase());
    }

    public String generateUrl(String actionName, TreeMap<String, Object> params) {
        actionName = this.ucFirst(actionName);
        if (params == null) {
            params = new TreeMap();
        }
        params.put("Action", actionName);
        if (!params.containsKey("Region")) {
            params.put("Region", this.defaultRegion);
        }
        return Request.generateUrl(params, this.secretId, this.secretKey, this.requestMethod, this.serverHost, this.serverUri);
    }

    public String call(String actionName, TreeMap<String, Object> params) {
        return this.call(actionName, params, null);
    }

    public String call(String actionName, TreeMap<String, Object> params, String fileName) {
        actionName = this.ucFirst(actionName);
        if (params == null) {
            params = new TreeMap();
        }
        params.put("Action", actionName);
        if (!params.containsKey("Region")) {
            params.put("Region", this.defaultRegion);
        }
        String response = Request.send(params, this.secretId, this.secretKey, this.requestMethod, this.serverHost, this.serverUri, fileName);
        return response;
    }
}

