package com.qeagle.devtools.protocol.events.network;

/*-
 * #%L
 * cdt-java-client
 * %%
 * Copyright (C) 2018 - 2019 TL
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.qeagle.devtools.protocol.support.annotations.Experimental;
import com.qeagle.devtools.protocol.types.network.SignedExchangeInfo;

/** Fired when a signed exchange was received over the network */
@Experimental
public class SignedExchangeReceived {

  private String requestId;

  private SignedExchangeInfo info;

  /** Request identifier. */
  public String getRequestId() {
    return requestId;
  }

  /** Request identifier. */
  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }

  /** Information about the signed exchange response. */
  public SignedExchangeInfo getInfo() {
    return info;
  }

  /** Information about the signed exchange response. */
  public void setInfo(SignedExchangeInfo info) {
    this.info = info;
  }
}
