/*
 * Decompiled with CFR 0.152.
 */
package com.qeagle.devtools.protocol.definition.deserializers;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;

public class BaseSubTypeJsonDeserializer<T>
extends StdDeserializer<T> {
    private static final String TYPE_PROPERTY = "type";
    private static final String REF_PROPERTY = "$ref";
    private static final String ENUM_PROPERTY = "enum";
    private static final String STRING_PROPERTY_VALUE = "string";

    public BaseSubTypeJsonDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        ObjectCodec objectCodec = jsonParser.getCodec();
        ObjectNode objectNode = (ObjectNode)objectCodec.readTree(jsonParser);
        String typeValue = null;
        JsonNode type = objectNode.get(TYPE_PROPERTY);
        if (type != null) {
            typeValue = type.asText();
            if (STRING_PROPERTY_VALUE.equals(typeValue) && objectNode.get(ENUM_PROPERTY) != null) {
                typeValue = ENUM_PROPERTY;
            }
        } else if (objectNode.get(REF_PROPERTY) != null) {
            typeValue = "ref";
        }
        if (typeValue == null) {
            throw new JsonParseException(jsonParser, "Unknown object type.");
        }
        DeserializationConfig config = context.getConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)config, (Class)this.handledType());
        List subtypes = config.getAnnotationIntrospector().findSubtypes((Annotated)annotatedClass);
        for (NamedType namedType : subtypes) {
            if (!typeValue.equals(namedType.getName())) continue;
            return (T)objectCodec.treeToValue((TreeNode)objectNode, namedType.getType());
        }
        throw new JsonParseException(jsonParser, "Unknown object type " + typeValue + ".");
    }
}

