/*
 * Decompiled with CFR 0.152.
 */
package com.qeagle.devtools.utils;

import com.qeagle.devtools.protocol.support.types.EventHandler;
import com.qeagle.devtools.protocol.support.types.EventListener;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;

public final class ChromeDevToolsUtils {
    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static <T> void waitForEvent(Function<EventHandler<T>, EventListener> eventConsumer) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        EventListener eventListener = eventConsumer.apply(event -> countDownLatch.countDown());
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting for event.", e);
        }
        finally {
            eventListener.unsubscribe();
        }
    }
}

