/*
 * Decompiled with CFR 0.152.
 */
package com.qeagle.devtools.utils;

import com.qeagle.devtools.protocol.commands.Emulation;
import com.qeagle.devtools.protocol.types.page.CaptureScreenshotFormat;
import com.qeagle.devtools.protocol.types.page.LayoutMetrics;
import com.qeagle.devtools.protocol.types.page.Viewport;
import com.qeagle.devtools.services.ChromeDevToolsService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;

public class FullScreenshot {
    public static void captureFullPageScreenshot(ChromeDevToolsService devToolsService, String outputFilename) {
        LayoutMetrics layoutMetrics = devToolsService.getPage().getLayoutMetrics();
        double width = layoutMetrics.getContentSize().getWidth();
        double height = layoutMetrics.getContentSize().getHeight();
        Emulation emulation = devToolsService.getEmulation();
        emulation.setDeviceMetricsOverride(Double.valueOf(width).intValue(), Double.valueOf(height).intValue(), 1.0, Boolean.FALSE);
        Viewport viewport = new Viewport();
        viewport.setScale(1.0);
        viewport.setX(0.0);
        viewport.setY(0.0);
        viewport.setWidth(width);
        viewport.setHeight(height);
        FullScreenshot.storeAsFile(outputFilename, devToolsService.getPage().captureScreenshot(CaptureScreenshotFormat.PNG, 100, viewport, Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeAsFile(String fileName, String data) {
        OutputStream fileOutputStream = null;
        try {
            File file = new File(fileName);
            fileOutputStream = new FileOutputStream(file);
            ((FileOutputStream)fileOutputStream).write(Base64.getDecoder().decode(data));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

