/*
 * Decompiled with CFR 0.152.
 */
package haxe.io;

import haxe.io.Bytes;
import haxe.io.Error;
import haxe.io.FPHelper;
import haxe.lang.Closure;
import haxe.lang.EmptyObject;
import haxe.lang.HaxeException;
import haxe.lang.HxObject;
import haxe.lang.Runtime;
import haxe.root.Array;
import java.io.ByteArrayOutputStream;

public class BytesBuffer
extends HxObject {
    public ByteArrayOutputStream b;

    public BytesBuffer(EmptyObject emptyObject) {
    }

    public BytesBuffer() {
        BytesBuffer.__hx_ctor_haxe_io_BytesBuffer(this);
    }

    public static void __hx_ctor_haxe_io_BytesBuffer(BytesBuffer bytesBuffer) {
        bytesBuffer.b = new ByteArrayOutputStream();
    }

    public static Object __hx_createEmpty() {
        return new BytesBuffer(EmptyObject.EMPTY);
    }

    public static Object __hx_create(Array array) {
        return new BytesBuffer();
    }

    public final int get_length() {
        return this.b.size();
    }

    public final void addByte(int n) {
        try {
            this.b.write(n);
        }
        catch (Throwable throwable) {
            throw HaxeException.wrap(throwable);
        }
    }

    public final void add(Bytes bytes) {
        try {
            this.b.write(bytes.b, 0, bytes.length);
        }
        catch (Throwable throwable) {
            throw HaxeException.wrap(throwable);
        }
    }

    public final void addString(String string) {
        try {
            Bytes bytes = Bytes.ofString(string);
            this.b.write(bytes.b, 0, bytes.length);
        }
        catch (Throwable throwable) {
            throw HaxeException.wrap(throwable);
        }
    }

    public void addInt32(int n) {
        try {
            this.b.write(n & 0xFF);
            this.b.write(n >> 8 & 0xFF);
            this.b.write(n >> 16 & 0xFF);
            this.b.write(n >>> 24);
        }
        catch (Throwable throwable) {
            throw HaxeException.wrap(throwable);
        }
    }

    public void addInt64(long l) {
        this.addInt32(Runtime.toInt(l));
        this.addInt32(Runtime.toInt(l >> 32));
    }

    public final void addFloat(double d) {
        this.addInt32(FPHelper.floatToI32(d));
    }

    public final void addDouble(double d) {
        this.addInt64(FPHelper.doubleToI64(d));
    }

    public final void addBytes(Bytes bytes, int n, int n2) {
        try {
            if (n < 0 || n2 < 0 || n + n2 > bytes.length) {
                throw HaxeException.wrap(Error.OutsideBounds);
            }
            this.b.write(bytes.b, n, n2);
        }
        catch (Throwable throwable) {
            throw HaxeException.wrap(throwable);
        }
    }

    public Bytes getBytes() {
        byte[] byArray = this.b.toByteArray();
        Bytes bytes = new Bytes(byArray.length, byArray);
        this.b = null;
        return bytes;
    }

    @Override
    public Object __hx_setField(String string, Object object, boolean bl) {
        boolean bl2 = true;
        switch (string.hashCode()) {
            case 98: {
                if (!string.equals("b")) break;
                bl2 = false;
                this.b = (ByteArrayOutputStream)object;
                return object;
            }
        }
        if (bl2) {
            return super.__hx_setField(string, object, bl);
        }
        throw null;
    }

    @Override
    public Object __hx_getField(String string, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = true;
        switch (string.hashCode()) {
            case 1950049973: {
                if (!string.equals("getBytes")) break;
                bl4 = false;
                return new Closure(this, "getBytes");
            }
            case 98: {
                if (!string.equals("b")) break;
                bl4 = false;
                return this.b;
            }
            case -1262447542: {
                if (!string.equals("addBytes")) break;
                bl4 = false;
                return new Closure(this, "addBytes");
            }
            case -1106363674: {
                if (!string.equals("length")) break;
                bl4 = false;
                return this.get_length();
            }
            case -433118254: {
                if (!string.equals("addDouble")) break;
                bl4 = false;
                return new Closure(this, "addDouble");
            }
            case 974314479: {
                if (!string.equals("get_length")) break;
                bl4 = false;
                return new Closure(this, "get_length");
            }
            case -1259145669: {
                if (!string.equals("addFloat")) break;
                bl4 = false;
                return new Closure(this, "addFloat");
            }
            case -1149102775: {
                if (!string.equals("addByte")) break;
                bl4 = false;
                return new Closure(this, "addByte");
            }
            case -1256312116: {
                if (!string.equals("addInt64")) break;
                bl4 = false;
                return new Closure(this, "addInt64");
            }
            case 96417: {
                if (!string.equals("add")) break;
                bl4 = false;
                return new Closure(this, "add");
            }
            case -1256312211: {
                if (!string.equals("addInt32")) break;
                bl4 = false;
                return new Closure(this, "addInt32");
            }
            case 854034: {
                if (!string.equals("addString")) break;
                bl4 = false;
                return new Closure(this, "addString");
            }
        }
        if (bl4) {
            return super.__hx_getField(string, bl, bl2, bl3);
        }
        throw null;
    }

    @Override
    public double __hx_getField_f(String string, boolean bl, boolean bl2) {
        boolean bl3 = true;
        switch (string.hashCode()) {
            case -1106363674: {
                if (!string.equals("length")) break;
                bl3 = false;
                return this.get_length();
            }
        }
        if (bl3) {
            return super.__hx_getField_f(string, bl, bl2);
        }
        throw null;
    }

    @Override
    public Object __hx_invokeField(String string, Array array) {
        boolean bl = true;
        switch (string.hashCode()) {
            case 1950049973: {
                if (!string.equals("getBytes")) break;
                bl = false;
                return this.getBytes();
            }
            case 974314479: {
                if (!string.equals("get_length")) break;
                bl = false;
                return this.get_length();
            }
            case -1262447542: {
                if (!string.equals("addBytes")) break;
                bl = false;
                this.addBytes((Bytes)array.__get(0), Runtime.toInt(array.__get(1)), Runtime.toInt(array.__get(2)));
                break;
            }
            case -1149102775: {
                if (!string.equals("addByte")) break;
                bl = false;
                this.addByte(Runtime.toInt(array.__get(0)));
                break;
            }
            case -433118254: {
                if (!string.equals("addDouble")) break;
                bl = false;
                this.addDouble(Runtime.toDouble(array.__get(0)));
                break;
            }
            case 96417: {
                if (!string.equals("add")) break;
                bl = false;
                this.add((Bytes)array.__get(0));
                break;
            }
            case -1259145669: {
                if (!string.equals("addFloat")) break;
                bl = false;
                this.addFloat(Runtime.toDouble(array.__get(0)));
                break;
            }
            case 854034: {
                if (!string.equals("addString")) break;
                bl = false;
                this.addString(Runtime.toString(array.__get(0)));
                break;
            }
            case -1256312116: {
                if (!string.equals("addInt64")) break;
                bl = false;
                this.addInt64((Long)array.__get(0));
                break;
            }
            case -1256312211: {
                if (!string.equals("addInt32")) break;
                bl = false;
                this.addInt32(Runtime.toInt(array.__get(0)));
            }
        }
        if (bl) {
            return super.__hx_invokeField(string, array);
        }
        return null;
    }

    @Override
    public void __hx_getFields(Array<String> array) {
        array.push("length");
        array.push("b");
        super.__hx_getFields(array);
    }
}

