/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Options;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.util.Logging;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Coverage {
    private static final Class<?> CLASS = Coverage.class;
    private static final Level loggingLevel = Level.CONFIG;
    private static final Logger logger = Logger.getLogger(CLASS.getName());

    private Coverage() {
    }

    public static void main(String[] args) throws IOException, MalformedSchemaException {
        JsonElement instance;
        JsonElement schema;
        if (args.length != 2) {
            System.out.println("Usage: " + CLASS.getName() + " <schema> <instance>");
            System.exit(1);
            return;
        }
        URI schemaID = new URI(new File(args[0]).toURI());
        try {
            schema = Coverage.getFromURL(args[0], "Schema");
        }
        catch (MalformedURLException ex) {
            schema = JSON.parse(new File(args[0]));
        }
        try {
            instance = Coverage.getFromURL(args[1], "Instance");
        }
        catch (MalformedURLException ex) {
            instance = JSON.parse(new File(args[1]));
        }
        logger.info("Loaded schema=" + args[0] + " instance=" + args[1]);
        logger.info("Actual spec=" + Validator.specificationFromSchema(schema));
        logger.info("Guessed spec=" + Validator.guessSpecification(schema));
        Options opts = new Options();
        HashMap errors = new HashMap();
        long time = System.currentTimeMillis();
        Validator validator = new Validator(schema, schemaID, null, null, opts);
        boolean result = validator.validate(instance, null, errors);
        time = System.currentTimeMillis() - time;
        logger.info("Validation result: " + result + " (" + (double)time / 1000.0 + "s)");
        JsonObject instanceRoot = new JsonObject();
        JsonArray seenInstanceLocs = new JsonArray();
        instanceRoot.add("seen", (JsonElement)seenInstanceLocs);
        errors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            JsonObject instanceLoc = new JsonObject();
            instanceLoc.addProperty("instanceLocation", ((JSONPath)entry.getKey()).toString());
            JsonArray schemaLocs = new JsonArray();
            instanceLoc.add("schemaLocations", (JsonElement)schemaLocs);
            ((Map)entry.getValue()).values().stream().sorted(Comparator.comparing(err -> err.loc.keyword)).forEach(err -> {
                JsonObject schemaLoc = new JsonObject();
                schemaLoc.addProperty("keywordLocation", err.loc.keyword.toString());
                schemaLoc.addProperty("absoluteKeywordLocation", err.loc.absKeyword.toString());
                schemaLocs.add((JsonElement)schemaLoc);
            });
            seenInstanceLocs.add((JsonElement)instanceLoc);
        });
        JsonArray unseenInstanceLocs = new JsonArray();
        instanceRoot.add("unseen", (JsonElement)unseenInstanceLocs);
        JSON.traverse(instance, (e, parent, path) -> {
            if (!errors.containsKey(path)) {
                unseenInstanceLocs.add(path.toString());
            }
        });
        JsonObject schemaRoot = new JsonObject();
        JsonArray seenSchemaLocs = new JsonArray();
        schemaRoot.add("seen", (JsonElement)seenSchemaLocs);
        errors.forEach((instanceLoc, bySchema) -> bySchema.values().forEach(err -> {
            JsonObject schemaLoc = new JsonObject();
            schemaLoc.addProperty("keywordLocation", err.loc.keyword.toString());
            schemaLoc.addProperty("absoluteKeywordLocation", err.loc.absKeyword.toString());
            seenSchemaLocs.add((JsonElement)schemaLoc);
        }));
        System.out.println("By instance location:");
        JSON.print(System.out, (JsonElement)instanceRoot, "    ");
        System.out.println();
        System.out.println();
        System.out.println("By schema location (seen only):");
        JSON.print(System.out, (JsonElement)schemaRoot, "    ");
        System.out.println();
    }

    private static Set<JSONPath> mapSchema(JsonElement schema, Specification defaultSpec) {
        HashSet<JSONPath> paths = new HashSet<JSONPath>();
        try {
            JSON.traverseSchema(URI.parseUnchecked(""), defaultSpec, schema, (e, parent, path, state) -> {
                if (state.isNotKeyword()) {
                    return;
                }
                if (parent != null && parent.isJsonArray()) {
                    return;
                }
                paths.add(path);
            });
        }
        catch (MalformedSchemaException ex) {
            throw new RuntimeException(ex);
        }
        return paths;
    }

    private static JsonElement getFromURL(String spec, String name) throws IOException {
        URL url = new URL(spec);
        URLConnection conn = url.openConnection();
        logger.info(Optional.ofNullable(conn.getContentType()).map(s -> name + " URL: Content-Type=" + s).orElse(name + " URL: has no Content-Type"));
        return JSON.parse(conn.getInputStream());
    }

    static {
        Logging.init(logger, loggingLevel);
    }
}

