/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonWriter;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.URIs;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class JSON {
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("[A-Z_a-z][-A-Z_a-z.0-9]*");

    private JSON() {
    }

    public static JsonElement parse(File f) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));){
            JsonElement jsonElement = JSON.parse(in);
            return jsonElement;
        }
    }

    public static JsonElement parse(URL url) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(url.openStream());){
            JsonElement jsonElement = JSON.parse(in);
            return jsonElement;
        }
    }

    public static JsonElement parse(InputStream in) {
        return JSON.parse(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public static JsonElement parse(Reader r) {
        return JsonParser.parseReader((Reader)r);
    }

    public static void print(OutputStream out, JsonElement json, String indent) throws IOException {
        Objects.requireNonNull(out, "out");
        Objects.requireNonNull(json, "json");
        JSON.print(new OutputStreamWriter(out), json, indent);
    }

    public static void print(Writer w, JsonElement json, String indent) throws IOException {
        Objects.requireNonNull(w, "w");
        Objects.requireNonNull(json, "json");
        BufferedWriter bw = w instanceof BufferedWriter ? (BufferedWriter)w : new BufferedWriter(w);
        JsonWriter jsonW = new JsonWriter((Writer)bw);
        if (indent != null) {
            jsonW.setIndent(indent);
        }
        try {
            new Gson().toJson(json, jsonW);
        }
        catch (JsonIOException ex) {
            Throwable th = ex.getCause();
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            throw ex;
        }
        jsonW.flush();
    }

    public static boolean isBoolean(JsonElement e) {
        return e.isJsonPrimitive() && e.getAsJsonPrimitive().isBoolean();
    }

    public static boolean isNumber(JsonElement e) {
        return e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber();
    }

    public static boolean isString(JsonElement e) {
        return e.isJsonPrimitive() && e.getAsJsonPrimitive().isString();
    }

    public static String getStringMember(JsonElement e, String name) {
        JsonElement titleElem;
        if (e.isJsonObject() && (titleElem = e.getAsJsonObject().get(name)) != null && JSON.isString(titleElem)) {
            return titleElem.getAsString();
        }
        return null;
    }

    public static URI traverseSchema(URI baseURI, Specification defaultSpec, JsonElement schema, SchemaVisitor visitor) throws MalformedSchemaException {
        Objects.requireNonNull(baseURI, "baseURI");
        SchemaTraverseState state = new SchemaTraverseState();
        state.spec = defaultSpec;
        state.rootURI = state.base = URIs.stripFragment(baseURI).normalize();
        return JSON.traverseSchema(schema, null, JSONPath.absolute(), state, visitor);
    }

    private static URI traverseSchema(JsonElement e, JsonElement parent, JSONPath path, SchemaTraverseState state, SchemaVisitor visitor) throws MalformedSchemaException {
        Specification spec;
        SchemaTraverseState oldState = state;
        state = new SchemaTraverseState();
        state.spec = oldState.spec;
        state.rootURI = oldState.rootURI;
        state.rootID = oldState.rootID;
        state.base = oldState.base;
        state.baseParent = oldState.baseParent;
        state.pathFromBase = oldState.pathFromBase;
        state.inProperties = false;
        state.inDefs = false;
        state.isNotSchema = false;
        boolean bl = state.isNotKeyword = oldState.inProperties || oldState.inDefs;
        if (!state.isNotKeyword) {
            if (path.endsWith("properties")) {
                state.inProperties = true;
                state.isNotSchema = true;
            } else if (path.endsWith("$defs")) {
                if (state.spec == null || state.spec.compareTo(Specification.DRAFT_2019_09) >= 0) {
                    state.inDefs = true;
                    state.isNotSchema = true;
                }
            } else if (path.endsWith("definitions") && (state.spec == null || state.spec.compareTo(Specification.DRAFT_2019_09) < 0)) {
                state.inDefs = true;
                state.isNotSchema = true;
            }
        }
        if (!state.isNotSchema && (spec = Validator.specificationFromSchema(e)) != null) {
            state.spec = spec;
        }
        state.idElem = null;
        state.anchorElem = null;
        state.id = null;
        state.pathFromBase = parent == null ? JSONPath.absolute() : state.pathFromBase.append(path.get(path.size() - 1));
        if (!state.isNotSchema && e.isJsonObject()) {
            Iterator anchorElem;
            JsonElement idElem = e.getAsJsonObject().get("$id");
            if (idElem != null) {
                Supplier<URI> loc = () -> oldState.rootURI.resolve(Strings.jsonPointerToURI(path.append("$id").toString()));
                if (!JSON.isString(idElem)) {
                    throw new MalformedSchemaException("not a string", loc.get());
                }
                try {
                    URI unresolvedID = URI.parse(idElem.getAsString()).normalize();
                    URI id = state.base.resolve(unresolvedID).normalize();
                    if (URIs.hasNonEmptyFragment(id)) {
                        if (state.spec != null && state.spec.compareTo(Specification.DRAFT_2019_09) >= 0) {
                            throw new MalformedSchemaException("has a non-empty fragment", loc.get());
                        }
                        if (!ANCHOR_PATTERN.matcher(id.fragment()).matches()) {
                            throw new MalformedSchemaException("invalid plain name", loc.get());
                        }
                    } else {
                        id = URIs.stripFragment(id);
                    }
                    state.idElem = idElem;
                    state.baseParent = state.base;
                    state.base = id;
                    state.id = unresolvedID;
                    state.pathFromBase = JSONPath.absolute();
                    if (parent == null) {
                        state.rootID = id;
                    }
                }
                catch (URISyntaxException ex) {
                    throw new MalformedSchemaException("not a valid URI-reference", loc.get());
                }
            }
            if (state.spec != null && state.spec.compareTo(Specification.DRAFT_2019_09) >= 0 && (anchorElem = e.getAsJsonObject().get("$anchor")) != null) {
                Supplier<URI> loc = () -> oldState.rootURI.resolve(Strings.jsonPointerToURI(path.append("$anchor").toString()));
                if (!JSON.isString((JsonElement)anchorElem)) {
                    throw new MalformedSchemaException("not a string", loc.get());
                }
                if (!ANCHOR_PATTERN.matcher(anchorElem.getAsString()).matches()) {
                    throw new MalformedSchemaException("invalid plain name", loc.get());
                }
                state.anchorElem = anchorElem;
            }
        }
        visitor.visit(e, parent, path, state);
        if (e.isJsonPrimitive() || e.isJsonNull()) {
            return state.rootID;
        }
        if (e.isJsonArray()) {
            int index = 0;
            for (JsonElement item : e.getAsJsonArray()) {
                JSON.traverseSchema(item, e, path.append(Integer.toString(index)), state, visitor);
                ++index;
            }
        } else {
            for (Map.Entry entry : e.getAsJsonObject().entrySet()) {
                JSON.traverseSchema((JsonElement)entry.getValue(), e, path.append((String)entry.getKey()), state, visitor);
            }
        }
        return state.rootID;
    }

    public static void traverse(JsonElement e, Visitor visitor) {
        JSON.traverse(e, null, JSONPath.absolute(), visitor);
    }

    private static void traverse(JsonElement e, JsonElement parent, JSONPath path, Visitor visitor) {
        visitor.visit(e, parent, path);
        if (e.isJsonPrimitive() || e.isJsonNull()) {
            return;
        }
        if (e.isJsonArray()) {
            int index = 0;
            for (JsonElement item : e.getAsJsonArray()) {
                JSON.traverse(item, e, path.append(Integer.toString(index)), visitor);
                ++index;
            }
        } else {
            for (Map.Entry entry : e.getAsJsonObject().entrySet()) {
                JSON.traverse((JsonElement)entry.getValue(), e, path.append((String)entry.getKey()), visitor);
            }
        }
    }

    public static final class SchemaTraverseState {
        Specification spec;
        boolean inProperties;
        boolean inDefs;
        boolean isNotKeyword;
        boolean isNotSchema;
        URI rootURI;
        URI rootID;
        URI base;
        URI id;
        URI baseParent;
        JSONPath pathFromBase;
        JsonElement idElem;
        JsonElement anchorElem;

        SchemaTraverseState() {
        }

        public Specification spec() {
            return this.spec;
        }

        public boolean isProperties() {
            return this.inProperties;
        }

        public boolean isDefs() {
            return this.inDefs;
        }

        public boolean isNotSchema() {
            return this.isNotSchema;
        }

        public boolean isNotKeyword() {
            return this.isNotKeyword;
        }

        public URI rootID() {
            return this.rootID;
        }

        public URI rootURI() {
            return this.rootURI;
        }

        public URI baseURI() {
            return this.base;
        }

        public URI idURI() {
            return this.id;
        }

        public URI baseURIParent() {
            return this.baseParent;
        }

        public JSONPath pathFromBase() {
            return this.pathFromBase;
        }

        public boolean hasIDElement() {
            return this.idElem != null;
        }

        public JsonElement idElement() {
            return this.idElem;
        }

        public boolean hasAnchorElement() {
            return this.anchorElem != null;
        }

        public JsonElement anchorElement() {
            return this.anchorElem;
        }
    }

    public static interface SchemaVisitor {
        public void visit(JsonElement var1, JsonElement var2, JSONPath var3, SchemaTraverseState var4) throws MalformedSchemaException;
    }

    public static interface Visitor {
        public void visit(JsonElement var1, JsonElement var2, JSONPath var3);
    }
}

