/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.net.URI;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public final class JSONPath
extends AbstractList<String>
implements Iterable<String>,
Comparable<JSONPath> {
    private final boolean isAbsolute;
    private final List<String> list;

    public static JSONPath absolute() {
        return new JSONPath(true, Collections.emptyList());
    }

    public static JSONPath relative() {
        return new JSONPath(false, Collections.emptyList());
    }

    public static JSONPath fromElement(String element) {
        return new JSONPath(false, List.of(element));
    }

    public static JSONPath fromPath(String s) {
        return JSONPath.fromPath(s, false);
    }

    public static JSONPath fromJSONPointer(String s) {
        return JSONPath.fromPath(s, true);
    }

    private static JSONPath fromPath(String s, boolean isJSONPtr) {
        if (s.isEmpty()) {
            return isJSONPtr ? JSONPath.absolute() : JSONPath.relative();
        }
        JSONPath p = new JSONPath(s.startsWith("/"), new ArrayList<String>());
        int index = s.indexOf("/");
        if (index < 0) {
            p.addElement(s, isJSONPtr);
            return p;
        }
        if (index > 0) {
            p.addElement(s.substring(0, index), isJSONPtr);
        }
        while (true) {
            int next;
            if ((next = s.indexOf(47, index + 1)) < 0) break;
            p.addElement(s.substring(index + 1, next), isJSONPtr);
            index = next;
        }
        p.addElement(s.substring(index + 1), isJSONPtr);
        return p;
    }

    private JSONPath(boolean isAbsolute, List<String> list) {
        this.isAbsolute = isAbsolute;
        this.list = list;
    }

    private JSONPath(JSONPath p) {
        this(p.isAbsolute, new ArrayList<String>(p.list));
    }

    private void addElement(String element, boolean isJSONPtr) {
        Objects.requireNonNull(element, "element");
        if (isJSONPtr) {
            this.list.add(Strings.fromJSONPointerToken(element));
        } else {
            this.list.add(element);
        }
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    @Override
    public String get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public JSONPath append(String element) {
        Objects.requireNonNull(element, "element");
        JSONPath p = new JSONPath(this.isAbsolute, new ArrayList<String>(this.list.size() + 1));
        p.list.addAll(this.list);
        p.list.add(element);
        return p;
    }

    private void maybeRemoveLast() {
        if (!this.list.isEmpty()) {
            this.list.remove(this.list.size() - 1);
        }
    }

    public boolean startsWith(JSONPath p) {
        if (this.size() < p.size()) {
            return false;
        }
        return this.list.subList(0, p.size()).equals(p.list);
    }

    public boolean endsWith(String element) {
        return !this.list.isEmpty() && this.list.get(this.list.size() - 1).equals(element);
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    public JSONPath normalize() {
        JSONPath np = new JSONPath(this.isAbsolute(), new ArrayList<String>(this.size()));
        for (int i = 0; i < this.size(); ++i) {
            String e1 = this.get(i);
            if (!this.isAbsolute() && (e1.equals("..") || e1.equals("."))) continue;
            if (this.isAbsolute() && e1.equals(".")) {
                if (i + 1 < this.size()) continue;
                np.list.add("");
                continue;
            }
            if (this.isAbsolute() && e1.equals("..")) {
                np.maybeRemoveLast();
                if (i + 1 < this.size()) continue;
                np.list.add("");
                continue;
            }
            np.list.add(e1);
        }
        return np;
    }

    public JSONPath resolve(JSONPath p) {
        if (p.isAbsolute()) {
            return p.normalize();
        }
        JSONPath np = new JSONPath(this);
        if (p.list.isEmpty()) {
            return np;
        }
        if (!this.isAbsolute() || !this.list.isEmpty()) {
            np.maybeRemoveLast();
        }
        np.list.addAll(p.list);
        return np.normalize();
    }

    public String toURIFragmentID() {
        return "#" + URI.encodeFragment(this.toString());
    }

    @Override
    public int compareTo(JSONPath p) {
        if (this.isAbsolute() != p.isAbsolute()) {
            if (this.isAbsolute()) {
                return 1;
            }
            return -1;
        }
        int limit = Math.min(this.size(), p.size());
        for (int i = 0; i < limit; ++i) {
            int r = this.get(i).compareTo(p.get(i));
            if (r == 0) continue;
            return r;
        }
        return this.size() - p.size();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isAbsolute, this.list);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JSONPath)) {
            return false;
        }
        return this.isAbsolute == ((JSONPath)obj).isAbsolute && this.list.equals(((JSONPath)obj).list);
    }

    @Override
    public String toString() {
        if (this.list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isAbsolute()) {
            sb.append('/');
        }
        sb.append(this.list.get(0));
        IntStream.range(1, this.list.size()).forEach((int i) -> sb.append('/').append(Strings.jsonPointerToken(this.list.get(i))));
        return sb.toString();
    }
}

