/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.qindesign.json.schema.Annotation;
import com.qindesign.json.schema.Error;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Options;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.util.Logging;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static final Class<?> CLASS = Main.class;
    private static final Level loggingLevel = Level.CONFIG;
    private static final Logger logger = Logger.getLogger(CLASS.getName());
    private static final Specification spec;

    private Main() {
    }

    public static void main(String[] args) throws IOException, MalformedSchemaException {
        JsonElement instance;
        JsonElement schema;
        if (args.length != 2) {
            System.out.println("Usage: " + CLASS.getName() + " <schema> <instance>");
            System.exit(1);
            return;
        }
        URI schemaID = new URI(new File(args[0]).toURI());
        try {
            schema = Main.getFromURL(args[0], "Schema");
        }
        catch (MalformedURLException ex) {
            schema = JSON.parse(new File(args[0]));
        }
        try {
            instance = Main.getFromURL(args[1], "Instance");
        }
        catch (MalformedURLException ex) {
            instance = JSON.parse(new File(args[1]));
        }
        logger.info("Loaded schema=" + args[0] + " instance=" + args[1]);
        logger.info("Actual spec=" + Validator.specificationFromSchema(schema));
        logger.info("Guessed spec=" + Validator.guessSpecification(schema));
        Options opts = new Options();
        opts.set(Option.FORMAT, true);
        opts.set(Option.CONTENT, true);
        opts.set(Option.DEFAULT_SPECIFICATION, (Object)spec);
        HashMap annotations = new HashMap();
        HashMap errors = new HashMap();
        long time = System.currentTimeMillis();
        Validator validator = new Validator(schema, schemaID, null, null, opts);
        boolean result = validator.validate(instance, annotations, errors);
        time = System.currentTimeMillis() - time;
        logger.info("Validation result: " + result + " (" + (double)time / 1000.0 + "s)");
        System.out.println("Basic output:");
        JSON.print(System.out, (JsonElement)Main.basicOutput(result, errors), "    ");
        System.out.println();
        System.out.println();
        System.out.println("Annotations:");
        JSON.print(System.out, (JsonElement)Main.annotationOutput(annotations), "    ");
        System.out.println();
    }

    private static JsonElement getFromURL(String spec, String name) throws IOException {
        URL url = new URL(spec);
        URLConnection conn = url.openConnection();
        logger.info(Optional.ofNullable(conn.getContentType()).map(s -> name + " URL: Content-Type=" + s).orElse(name + " URL: has no Content-Type"));
        return JSON.parse(conn.getInputStream());
    }

    private static JsonObject basicOutput(boolean result, Map<JSONPath, Map<JSONPath, Error<?>>> errors) {
        JsonObject root = new JsonObject();
        root.addProperty("valid", Boolean.valueOf(result));
        JsonArray errorArr = new JsonArray();
        root.add("errors", (JsonElement)errorArr);
        errors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> ((Map)e.getValue()).values().stream().filter(err -> !err.isPruned() && !err.result).sorted(Comparator.comparing(err -> err.loc.keyword)).forEach(err -> {
            JsonObject error = new JsonObject();
            error.addProperty("keywordLocation", err.loc.keyword.toString());
            error.addProperty("absoluteKeywordLocation", err.loc.absKeyword.toString());
            error.addProperty("instanceLocation", err.loc.instance.toString());
            if (err.value != null) {
                error.addProperty("error", err.value.toString());
            }
            errorArr.add((JsonElement)error);
        }));
        return root;
    }

    private static JsonObject annotationOutput(Map<JSONPath, Map<String, Map<JSONPath, Annotation<?>>>> annotations) {
        JsonObject root = new JsonObject();
        JsonArray annotationArr = new JsonArray();
        root.add("annotations", (JsonElement)annotationArr);
        annotations.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> ((Map)e.getValue()).forEach((name, bySchemaLoc) -> bySchemaLoc.values().stream().sorted(Comparator.comparing(a -> a.loc.keyword)).forEach(a -> {
            JsonNull ae;
            JsonObject o = new JsonObject();
            o.addProperty("instanceLocation", a.loc.instance.toString());
            o.addProperty("keywordLocation", a.loc.keyword.toString());
            o.addProperty("absoluteKeywordLocation", a.loc.absKeyword.toString());
            JsonObject ao = new JsonObject();
            o.add("annotation", (JsonElement)ao);
            ao.addProperty("name", a.name);
            if (!a.isValid()) {
                ao.addProperty("valid", Boolean.valueOf(false));
            }
            if (a.value == null) {
                ae = JsonNull.INSTANCE;
            } else if (a.value instanceof Boolean) {
                ae = new JsonPrimitive((Boolean)a.value);
            } else if (a.value instanceof String) {
                ae = new JsonPrimitive((String)a.value);
            } else if (a.value instanceof Number) {
                ae = new JsonPrimitive((Number)a.value);
            } else if (a.value instanceof Collection) {
                JsonArray arr = new JsonArray();
                for (Object elem : (Collection)a.value) {
                    arr.add(String.valueOf(elem));
                }
                ae = arr;
            } else {
                ae = new JsonPrimitive(a.value.toString());
            }
            ao.add("value", (JsonElement)ae);
            annotationArr.add((JsonElement)o);
        })));
        return root;
    }

    static {
        Logging.init(logger, loggingLevel);
        spec = Specification.DRAFT_2019_09;
    }
}

