/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Specification;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Options {
    private static final Map<Specification, Map<Option, Object>> specDefaults = new HashMap<Specification, Map<Option, Object>>();
    private static final Map<Option, Object> defaults = new HashMap<Option, Object>();
    private final Map<Option, Object> options = new HashMap<Option, Object>();

    public Options() {
    }

    public Options(Options opts) {
        this.options.putAll(opts.options);
    }

    public Options set(Option option, Object value) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        if (!option.type().isInstance(value)) {
            throw new IllegalArgumentException("Bad value type: got=" + value.getClass() + " want=" + option.type());
        }
        this.options.put(option, value);
        return this;
    }

    public Object clear(Option option) {
        Objects.requireNonNull(option, "option");
        return this.options.remove((Object)option);
    }

    public Object get(Option option) {
        Objects.requireNonNull(option, "option");
        return this.options.getOrDefault((Object)option, defaults.get((Object)option));
    }

    public boolean is(Option option) {
        return Boolean.TRUE.equals(this.get(option));
    }

    public Object getForSpecification(Option option, Specification spec) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(spec, "spec");
        return this.options.getOrDefault((Object)option, specDefaults.getOrDefault((Object)spec, Collections.emptyMap()).getOrDefault((Object)option, defaults.get((Object)option)));
    }

    static {
        specDefaults.put(Specification.DRAFT_07, new HashMap());
        specDefaults.put(Specification.DRAFT_2019_09, new HashMap());
        specDefaults.get((Object)Specification.DRAFT_07).put(Option.FORMAT, true);
        specDefaults.get((Object)Specification.DRAFT_2019_09).put(Option.FORMAT, false);
        defaults.put(Option.FORMAT, false);
        defaults.put(Option.DEFAULT_SPECIFICATION, (Object)Specification.DRAFT_2019_09);
        defaults.put(Option.COLLECT_ANNOTATIONS_FOR_FAILED, false);
        defaults.put(Option.CONTENT, false);
    }
}

