/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Option;
import com.qindesign.json.schema.Options;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import com.qindesign.json.schema.util.Logging;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Test {
    private static final Class<?> CLASS = Test.class;
    private static final Level loggingLevel = Level.CONFIG;
    private static final Logger logger = Logger.getLogger(CLASS.getName());
    private static final String TEST_SCHEMA = "test-schema.json";
    private static final Map<Specification, String> testDirs;

    private Test() {
    }

    public static void main(String[] args) throws IOException {
        JsonElement testSchema;
        if (args.length < 1 || 2 < args.length) {
            System.out.println("Usage: " + CLASS.getName() + " <suite location> [output file]");
            System.exit(1);
            return;
        }
        Path root = Path.of(args[0], new String[0]);
        if (!root.toFile().isDirectory()) {
            logger.severe("Not a directory: " + args[0]);
            System.exit(1);
            return;
        }
        File testSchemaFile = root.resolve(TEST_SCHEMA).toFile();
        long time = System.currentTimeMillis();
        try {
            testSchema = JSON.parse(testSchemaFile);
        }
        catch (JsonParseException ex) {
            logger.log(Level.SEVERE, "Could not parse test schema: " + testSchemaFile, ex);
            System.exit(1);
            return;
        }
        time = System.currentTimeMillis() - time;
        logger.info("Loaded test schema (" + (float)time / 1000.0f + "s)");
        Map<URI, JsonElement> knownIDs = Collections.emptyMap();
        Map<URI, URL> knownURLs = Map.of(URI.parseUnchecked("http://localhost:1234"), root.resolve("remotes").toUri().toURL());
        JsonArray specOutputArr = null;
        if (args.length >= 2) {
            specOutputArr = new JsonArray();
        }
        time = System.currentTimeMillis();
        for (Specification spec : Specification.values()) {
            if (!testDirs.containsKey((Object)spec)) continue;
            System.out.println();
            Path testDir = root.resolve("tests/" + testDirs.get((Object)spec));
            if (!testDir.toFile().isDirectory()) {
                logger.severe("Not a directory: " + testDir);
                continue;
            }
            logger.info("Running tests: " + spec);
            TreeMap<String, Result> results = new TreeMap<String, Result>();
            JsonArray testOutputArr = null;
            if (specOutputArr != null) {
                JsonObject specObj = new JsonObject();
                specOutputArr.add((JsonElement)specObj);
                specObj.addProperty("spec", spec.toString());
                testOutputArr = new JsonArray();
                specObj.add("tests", (JsonElement)testOutputArr);
            }
            Result specResult = Test.runSpec(root, testDir, testSchema, testSchemaFile, results, spec, knownIDs, knownURLs, testOutputArr);
            Test.printSpecResults(spec, specResult, results);
        }
        time = System.currentTimeMillis() - time;
        System.out.println();
        logger.info("Total test time: " + (float)time / 1000.0f + "s");
        if (specOutputArr != null) {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(args[1]));){
                JSON.print(bw, (JsonElement)specOutputArr, "    ");
                bw.newLine();
                bw.flush();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error writing output", ex);
            }
        }
    }

    private static void printSpecResults(Specification spec, Result specResult, Map<String, Result> results) {
        System.out.println("Results for specification: " + spec);
        int maxLen = results.keySet().stream().mapToInt(String::length).max().orElse(1);
        System.out.printf("%-" + maxLen + "s  %-4s  %-4s  %-5s  %-8s\n", "Name", "Pass", "Fail", "Total", "Duration");
        IntStream.range(0, maxLen + 29).forEach(i -> System.out.print('-'));
        System.out.println();
        results.forEach((name, result) -> System.out.printf("%-" + maxLen + "s  %4d  %4d  %5d  %7ss\n", name, result.passed, result.total - result.passed, result.total, Test.formatDuration(result.duration)));
        IntStream.range(0, maxLen + 29).forEach(i -> System.out.print('-'));
        System.out.println();
        System.out.printf("Pass:%d (%d opt) Fail:%d (%d opt) Total:%d (%d opt) Time:%ss\n", specResult.passed, specResult.passedOptional, specResult.total - specResult.passed, specResult.totalOptional - specResult.passedOptional, specResult.total, specResult.totalOptional, Test.formatDuration(specResult.duration).trim());
        System.out.println("Times:");
        System.out.printf("  Test: %ss\n", Test.formatDuration(specResult.duration).trim());
        System.out.printf("  Other: %ss\n", Test.formatDuration(specResult.totalDuration - specResult.duration).trim());
        System.out.printf("  Total: %ss\n", Test.formatDuration(specResult.totalDuration).trim());
    }

    private static String formatDuration(long millis) {
        return String.format("%2d.%03d", millis / 1000L, millis % 1000L);
    }

    private static Result runSpec(final Path root, final Path dir, final JsonElement testSchema, final File testSchemaFile, final Map<String, Result> results, final Specification spec, final Map<URI, JsonElement> knownIDs, final Map<URI, URL> knownURLs, final JsonArray testOutputArr) throws IOException {
        final Result result = new Result();
        long start = System.currentTimeMillis();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                JsonElement instance;
                try {
                    instance = JSON.parse(file.toFile());
                }
                catch (JsonParseException ex) {
                    logger.log(Level.WARNING, "Could not parse test suite: " + file, ex);
                    return FileVisitResult.CONTINUE;
                }
                logger.fine("Validating test suite: " + file);
                Options opts = new Options();
                opts.set(Option.FORMAT, false);
                opts.set(Option.CONTENT, false);
                opts.set(Option.DEFAULT_SPECIFICATION, (Object)spec);
                try {
                    Validator validator = new Validator(testSchema, new URI(testSchemaFile.toURI()), knownIDs, knownURLs, opts);
                    if (!validator.validate(instance, new HashMap(), null)) {
                        logger.warning("Not a valid test suite: " + file);
                        return FileVisitResult.CONTINUE;
                    }
                }
                catch (MalformedSchemaException ex) {
                    logger.log(Level.SEVERE, "Malformed schema: " + testSchemaFile, ex);
                    return FileVisitResult.CONTINUE;
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, "Bad validator argument: " + testSchemaFile, ex);
                    return FileVisitResult.CONTINUE;
                }
                Result r = Test.runSuite(root, file, instance.getAsJsonArray(), spec, knownIDs, knownURLs, testOutputArr);
                result.total += r.total;
                result.passed += r.passed;
                result.totalOptional += r.totalOptional;
                result.passedOptional += r.passedOptional;
                result.duration += r.duration;
                results.put(dir.relativize(file).toString(), r);
                return FileVisitResult.CONTINUE;
            }
        });
        result.totalDuration = System.currentTimeMillis() - start;
        return result;
    }

    private static Result runSuite(Path root, Path file, JsonArray suite, Specification spec, Map<URI, JsonElement> knownIDs, Map<URI, URL> knownURLs, JsonArray testOutputArr) {
        Result suiteResult = new Result();
        long start = System.currentTimeMillis();
        int groupIndex = 0;
        for (JsonElement g : suite) {
            JsonObject group = g.getAsJsonObject();
            String groupDescription = group.get("description").getAsString();
            JsonElement schema = group.get("schema");
            int testIndex = 0;
            for (JsonElement t : group.getAsJsonArray("tests")) {
                JsonObject test = t.getAsJsonObject();
                String description = test.get("description").getAsString();
                JsonElement data = test.get("data");
                boolean valid = test.get("valid").getAsBoolean();
                URI uri = new URI(file.toUri());
                try {
                    uri = new URI(uri.scheme(), uri.authority(), uri.path() + "/" + groupIndex + "/" + testIndex, uri.query(), null);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException(ex);
                }
                boolean isOptional = uri.rawPath().contains("/optional/");
                ++suiteResult.total;
                if (isOptional) {
                    ++suiteResult.totalOptional;
                }
                logger.fine("Testing " + uri);
                Options opts = new Options();
                opts.set(Option.FORMAT, true);
                opts.set(Option.CONTENT, true);
                opts.set(Option.DEFAULT_SPECIFICATION, (Object)spec);
                try {
                    boolean result;
                    Validator validator = new Validator(schema, uri, knownIDs, knownURLs, opts);
                    HashMap annotations = new HashMap();
                    HashMap errors = null;
                    if (testOutputArr != null) {
                        errors = new HashMap();
                    }
                    if ((result = validator.validate(data, annotations, errors)) != valid) {
                        logger.info(new URI(root.toUri()).relativize(uri) + ": Bad result: " + groupDescription + ": " + description + ": got=" + result + " want=" + valid);
                    } else {
                        ++suiteResult.passed;
                        if (isOptional) {
                            ++suiteResult.passedOptional;
                        }
                    }
                    if (testOutputArr != null) {
                        JsonObject testObj = new JsonObject();
                        testOutputArr.add((JsonElement)testObj);
                        testObj.addProperty("test", uri.toString());
                        testObj.addProperty("passed", Boolean.valueOf(result == valid));
                        testObj.addProperty("valid", Boolean.valueOf(result));
                        JsonArray errorArr = new JsonArray();
                        testObj.add("errors", (JsonElement)errorArr);
                        JsonArray annotationArr = new JsonArray();
                        testObj.add("annotations", (JsonElement)annotationArr);
                        errors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> ((Map)e.getValue()).values().stream().sorted(Comparator.comparing(err -> err.loc.keyword)).forEach(err -> {
                            JsonObject error = new JsonObject();
                            error.addProperty("keywordLocation", err.loc.keyword.toString());
                            error.addProperty("absoluteKeywordLocation", err.loc.absKeyword.toString());
                            error.addProperty("instanceLocation", err.loc.instance.toString());
                            if (err.isPruned()) {
                                error.addProperty("pruned", Boolean.valueOf(true));
                            }
                            error.addProperty("result", Boolean.valueOf(err.result));
                            if (err.value != null) {
                                error.addProperty("error", err.value.toString());
                            }
                            errorArr.add((JsonElement)error);
                        }));
                        annotations.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> ((Map)e.getValue()).forEach((name, bySchemaLoc) -> bySchemaLoc.values().stream().sorted(Comparator.comparing(a -> a.loc.keyword)).forEach(a -> {
                            JsonNull ae;
                            JsonObject o = new JsonObject();
                            o.addProperty("instanceLocation", a.loc.instance.toString());
                            o.addProperty("keywordLocation", a.loc.keyword.toString());
                            o.addProperty("absoluteKeywordLocation", a.loc.absKeyword.toString());
                            JsonObject ao = new JsonObject();
                            o.add("annotation", (JsonElement)ao);
                            ao.addProperty("name", a.name);
                            if (!a.isValid()) {
                                ao.addProperty("pruned", Boolean.valueOf(true));
                            }
                            if (a.value == null) {
                                ae = JsonNull.INSTANCE;
                            } else if (a.value instanceof Boolean) {
                                ae = new JsonPrimitive((Boolean)a.value);
                            } else if (a.value instanceof String) {
                                ae = new JsonPrimitive((String)a.value);
                            } else if (a.value instanceof Number) {
                                ae = new JsonPrimitive((Number)a.value);
                            } else if (a.value instanceof Collection) {
                                JsonArray arr = new JsonArray();
                                for (Object elem : (Collection)a.value) {
                                    arr.add(String.valueOf(elem));
                                }
                                ae = arr;
                            } else {
                                ae = new JsonPrimitive(a.value.toString());
                            }
                            ao.add("value", (JsonElement)ae);
                            annotationArr.add((JsonElement)o);
                        })));
                    }
                }
                catch (MalformedSchemaException ex) {
                    if (valid) {
                        logger.info(new URI(root.toUri()).relativize(uri) + ": Bad result: " + groupDescription + ": " + description + ": got=Malformed schema: " + ex.getMessage());
                    } else {
                        ++suiteResult.passed;
                        if (isOptional) {
                            ++suiteResult.passedOptional;
                        }
                    }
                }
                catch (IllegalArgumentException ex) {
                    logger.info(new URI(root.toUri()).relativize(uri) + ": Bad result: " + groupDescription + ": " + description + ": got=Bad argument: " + ex.getMessage());
                }
                ++testIndex;
            }
            ++groupIndex;
        }
        suiteResult.totalDuration = suiteResult.duration = System.currentTimeMillis() - start;
        return suiteResult;
    }

    static {
        Logging.init(logger, loggingLevel);
        testDirs = Stream.of({Specification.DRAFT_2019_09, "draft2019-09"}, {Specification.DRAFT_07, "draft7"}, {Specification.DRAFT_06, "draft6"}).collect(Collectors.toUnmodifiableMap(data -> (Specification)((Object)((Object)data[0])), data -> (String)data[1]));
    }

    private static final class Result {
        int total;
        int passed;
        int totalOptional;
        int passedOptional;
        long duration;
        long totalDuration;

        private Result() {
        }
    }
}

