/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AdditionalProperties
extends Keyword {
    public static final String NAME = "additionalProperties";

    public AdditionalProperties() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        context.checkValidSchema(value);
        if (!instance.isJsonObject()) {
            return true;
        }
        HashSet validated = new HashSet();
        Object propsA = context.localAnnotation("properties");
        if (propsA instanceof Set) {
            validated.addAll((Set)propsA);
        }
        if ((propsA = context.localAnnotation("patternProperties")) instanceof Set) {
            validated.addAll((Set)propsA);
        }
        StringBuilder sb = new StringBuilder();
        JsonObject object = instance.getAsJsonObject();
        HashSet<String> thisValidated = new HashSet<String>();
        if (validated.size() < object.size()) {
            for (Map.Entry e : object.entrySet()) {
                if (validated.contains(e.getKey())) continue;
                if (!context.apply(value, null, null, (JsonElement)e.getValue(), (String)e.getKey())) {
                    if (context.isFailFast()) {
                        return false;
                    }
                    if (sb.length() > 0) {
                        sb.append(", \"");
                    } else {
                        sb.append("invalid additional properties: \"");
                    }
                    sb.append(Strings.jsonString((String)e.getKey())).append('\"');
                }
                thisValidated.add((String)e.getKey());
            }
        }
        if (thisValidated.size() > 0) {
            context.addAnnotation(NAME, thisValidated);
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

