/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.URIs;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;

public class CoreRecursiveRef
extends Keyword {
    public static final String NAME = "$recursiveRef";

    public CoreRecursiveRef() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        URI uri;
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        try {
            uri = URI.parse(value.getAsString()).normalize();
        }
        catch (URISyntaxException ex) {
            context.schemaError("not a valid URI");
            return false;
        }
        if (!(uri.isAbsolute() || uri.rawAuthority() == null && uri.rawPath().isEmpty() && uri.rawQuery() == null)) {
            context.schemaError("not a lone octothorpe");
            return false;
        }
        if (URIs.hasNonEmptyFragment(uri)) {
            context.schemaError("has a non-empty fragment");
            return false;
        }
        URI resolved = URIs.stripFragment(context.baseURI().resolve(uri));
        JsonElement e = context.findAndSetRoot(resolved);
        if (e == null) {
            context.schemaError("unknown reference: " + value.getAsString());
            return false;
        }
        if (!Validator.isSchema(e)) {
            context.schemaError("reference not a schema: " + resolved);
            return false;
        }
        if (e.isJsonObject() && e.getAsJsonObject().has("$recursiveAnchor")) {
            JsonElement a = e.getAsJsonObject().get("$recursiveAnchor");
            if (!JSON.isBoolean(a)) {
                context.schemaError("referenced $recursiveAnchor not a Boolean: " + resolved);
                return false;
            }
            if (a.getAsBoolean()) {
                resolved = context.recursiveBaseURI().resolve(uri);
                e = context.findAndSetRoot(resolved);
                if (e == null) {
                    context.schemaError("unknown dynamic reference: " + resolved);
                    return false;
                }
                if (!Validator.isSchema(e)) {
                    context.schemaError("dynamic reference not a schema: " + resolved);
                    return false;
                }
            }
        }
        if (!context.apply(e, null, resolved, instance, null)) {
            context.addError(false, resolved.toString());
            return false;
        }
        return true;
    }
}

