/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Id;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.URIs;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.keywords.Format;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;

public class CoreRef
extends Keyword {
    public static final String NAME = "$ref";

    public CoreRef() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        JsonElement e;
        URI uri;
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        try {
            uri = URI.parse(value.getAsString()).normalize();
        }
        catch (URISyntaxException ex) {
            context.schemaError("not a valid URI");
            return false;
        }
        URI schemaURI = uri = context.baseURI().resolve(uri);
        String fragment = uri.fragment();
        if (fragment != null && Format.JSON_POINTER.matcher(fragment).matches()) {
            e = context.findAndSetRoot(uri = URIs.stripFragment(uri));
            if (e != null) {
                e = context.followPointer(uri, e, fragment);
            }
        } else {
            Id id;
            if (fragment != null && (id = context.findID(uri)) != null) {
                try {
                    schemaURI = new URI(id.base.scheme(), id.base.authority(), id.base.path(), id.base.query(), id.path.toString());
                }
                catch (URISyntaxException ex) {
                    context.schemaError("unexpected bad URI");
                    return false;
                }
            }
            e = context.findAndSetRoot(uri);
        }
        if (e == null) {
            context.schemaError("unknown reference: " + value.getAsString());
            return false;
        }
        if (!Validator.isSchema(e)) {
            context.schemaError("reference not a schema: " + value.getAsString());
            return false;
        }
        if (!context.apply(e, null, schemaURI, instance, null)) {
            context.addError(false, schemaURI.toString());
            return false;
        }
        return true;
    }
}

