/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.ValidatorContext;
import com.qindesign.json.schema.net.URI;
import com.qindesign.json.schema.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class CoreVocabulary
extends Keyword {
    public static final String NAME = "$vocabulary";

    public CoreVocabulary() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) < 0) {
            return true;
        }
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        if (!context.isMetaSchema()) {
            return true;
        }
        if (!context.isRootSchema()) {
            context.schemaError("appearance in subschema");
            return false;
        }
        HashMap<URI, Boolean> vocabularies = new HashMap<URI, Boolean>();
        for (Map.Entry entry : value.getAsJsonObject().entrySet()) {
            URI uri;
            try {
                uri = URI.parse((String)entry.getKey());
            }
            catch (URISyntaxException ex) {
                context.schemaError("not a valid URI", (String)entry.getKey());
                return false;
            }
            URI normalized = uri.normalize();
            if (!normalized.equals(uri)) {
                context.schemaError("URI not normalized", (String)entry.getKey());
                return false;
            }
            if (!JSON.isBoolean((JsonElement)entry.getValue())) {
                context.schemaError("not a Boolean", (String)entry.getKey());
                return false;
            }
            vocabularies.put(uri, ((JsonElement)entry.getValue()).getAsBoolean());
        }
        for (Map.Entry entry : vocabularies.entrySet()) {
            context.setVocabulary((URI)entry.getKey(), (Boolean)entry.getValue());
        }
        return true;
    }
}

