/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.ValidatorContext;
import java.util.HashSet;
import java.util.Map;

public class Dependencies
extends Keyword {
    public static final String NAME = "dependencies";

    public Dependencies() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) >= 0) {
            return true;
        }
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        if (!instance.isJsonObject()) {
            return true;
        }
        StringBuilder sbInvalid = new StringBuilder();
        StringBuilder sbNotFound = new StringBuilder();
        JsonObject object = instance.getAsJsonObject();
        for (Map.Entry e : value.getAsJsonObject().entrySet()) {
            if (Validator.isSchema((JsonElement)e.getValue())) {
                if (!object.has((String)e.getKey()) || context.apply((JsonElement)e.getValue(), (String)e.getKey(), null, instance, null)) continue;
                if (context.isFailFast()) {
                    return false;
                }
                if (sbInvalid.length() > 0) {
                    sbInvalid.append(", \"");
                } else {
                    sbInvalid.append("invalid dependent properties: \"");
                }
                sbInvalid.append(Strings.jsonString((String)e.getKey())).append('\"');
                continue;
            }
            if (((JsonElement)e.getValue()).isJsonArray()) {
                if (!object.has((String)e.getKey())) continue;
                int index = 0;
                HashSet<String> names = new HashSet<String>();
                for (JsonElement name : ((JsonElement)e.getValue()).getAsJsonArray()) {
                    if (!JSON.isString(name)) {
                        context.schemaError("not a string", JSONPath.fromElement((String)e.getKey()).append(Integer.toString(index)));
                        return false;
                    }
                    if (!names.add(name.getAsString())) {
                        context.schemaError("\"" + Strings.jsonString(name.getAsString()) + "\": not unique", JSONPath.fromElement((String)e.getKey()).append(Integer.toString(index)));
                        return false;
                    }
                    if (!object.has(name.getAsString())) {
                        if (context.isFailFast()) {
                            return false;
                        }
                        if (sbNotFound.length() > 0) {
                            sbNotFound.append(", \"");
                        } else {
                            sbNotFound.append("missing dependent properties: \"");
                        }
                        sbNotFound.append(Strings.jsonString(name.getAsString())).append('\"');
                    }
                    ++index;
                }
                continue;
            }
            context.schemaError("not a schema or array", (String)e.getKey());
            return false;
        }
        boolean retval = true;
        if (sbInvalid.length() > 0 && sbNotFound.length() > 0) {
            context.addError(false, sbInvalid + "; " + sbNotFound);
            retval = false;
        } else if (sbInvalid.length() > 0) {
            context.addError(false, sbInvalid.toString());
            retval = false;
        } else if (sbNotFound.length() > 0) {
            context.addError(false, sbNotFound.toString());
            retval = false;
        }
        return retval;
    }
}

