/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.JSONPath;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Specification;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.HashSet;
import java.util.Map;

public class DependentRequired
extends Keyword {
    public static final String NAME = "dependentRequired";

    public DependentRequired() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (context.specification().compareTo(Specification.DRAFT_2019_09) < 0) {
            return true;
        }
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        if (!instance.isJsonObject()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        JsonObject object = instance.getAsJsonObject();
        for (Map.Entry e : value.getAsJsonObject().entrySet()) {
            if (!((JsonElement)e.getValue()).isJsonArray()) {
                context.schemaError((String)e.getKey() + ": not an array");
                return false;
            }
            if (!object.has((String)e.getKey())) continue;
            int index = 0;
            HashSet<String> names = new HashSet<String>();
            for (JsonElement name : ((JsonElement)e.getValue()).getAsJsonArray()) {
                if (!JSON.isString(name)) {
                    context.schemaError("not a string", JSONPath.fromElement((String)e.getKey()).append(Integer.toString(index)));
                    return false;
                }
                if (!names.add(name.getAsString())) {
                    context.schemaError("\"" + Strings.jsonString(name.getAsString()) + "\": not unique", JSONPath.fromElement((String)e.getKey()).append(Integer.toString(index)));
                    return false;
                }
                if (!object.has(name.getAsString())) {
                    if (context.isFailFast()) {
                        return false;
                    }
                    if (sb.length() > 0) {
                        sb.append(", \"");
                    } else {
                        sb.append("missing dependent properties: \"");
                    }
                    sb.append(Strings.jsonString(name.getAsString())).append('\"');
                }
                ++index;
            }
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

