/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Numbers;
import com.qindesign.json.schema.ValidatorContext;
import java.math.BigDecimal;

public class ExclusiveMaximum
extends Keyword {
    public static final String NAME = "exclusiveMaximum";

    public ExclusiveMaximum() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        BigDecimal v;
        if (!JSON.isNumber(value)) {
            context.schemaError("not a number");
            return false;
        }
        if (!JSON.isNumber(instance)) {
            return true;
        }
        BigDecimal n = Numbers.valueOf(instance.getAsString());
        if (n.compareTo(v = Numbers.valueOf(value.getAsString())) >= 0) {
            context.addError(false, "want less than " + v + ", got " + n);
            return false;
        }
        return true;
    }
}

