/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Validator;
import com.qindesign.json.schema.ValidatorContext;

public class Items
extends Keyword {
    public static final String NAME = "items";

    public Items() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!Validator.isSchema(value) && !value.isJsonArray()) {
            context.schemaError("not a schema or array");
            return false;
        }
        if (!instance.isJsonArray()) {
            return true;
        }
        JsonArray array = instance.getAsJsonArray();
        StringBuilder sb = new StringBuilder();
        if (value.isJsonArray()) {
            JsonArray schemaArray = value.getAsJsonArray();
            int limit = Math.min(schemaArray.size(), array.size());
            for (int i = 0; i < limit; ++i) {
                String path = Integer.toString(i);
                if (context.apply(schemaArray.get(i), path, null, array.get(i), path)) continue;
                if (context.isFailFast()) {
                    return false;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                } else {
                    sb.append("invalid items in array: ");
                }
                sb.append(i);
            }
            if (0 < limit && limit < array.size()) {
                context.addAnnotation(NAME, limit - 1);
            } else {
                context.addAnnotation(NAME, true);
            }
        } else {
            int index = 0;
            for (JsonElement e : array) {
                if (!context.apply(value, null, null, e, Integer.toString(index))) {
                    if (context.isFailFast()) {
                        return false;
                    }
                    if (sb.length() > 0) {
                        sb.append(", ");
                    } else {
                        sb.append("invalid items: ");
                    }
                    sb.append(index);
                }
                ++index;
            }
            context.addAnnotation(NAME, true);
        }
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

