/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.ValidatorContext;

public class OneOf
extends Keyword {
    public static final String NAME = "oneOf";

    public OneOf() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!value.isJsonArray() || value.getAsJsonArray().size() == 0) {
            context.schemaError("not a non-empty array");
            return false;
        }
        StringBuilder sb = new StringBuilder();
        int validCount = 0;
        int index = 0;
        for (JsonElement e : value.getAsJsonArray()) {
            String name;
            if (context.apply(e, name = Integer.toString(index), null, instance, null)) {
                if (++validCount > 1 && context.isFailFast()) {
                    return false;
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(index);
            }
            ++index;
        }
        if (validCount != 1) {
            if (sb.length() > 0) {
                context.addError(false, "want 1 subschema valid, got " + validCount + ": " + sb);
            } else {
                context.addError(false, "want 1 subschema valid, got " + validCount);
            }
            return false;
        }
        return true;
    }
}

