/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.JSON;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.regex.PatternSyntaxException;

public class Pattern
extends Keyword {
    public static final String NAME = "pattern";

    public Pattern() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        java.util.regex.Pattern p;
        if (!JSON.isString(value)) {
            context.schemaError("not a string");
            return false;
        }
        try {
            p = context.pattern(value.getAsString());
        }
        catch (PatternSyntaxException ex) {
            context.schemaError("not a valid pattern");
            return false;
        }
        if (!JSON.isString(instance)) {
            return true;
        }
        if (!p.matcher(instance.getAsString()).find()) {
            context.addError(false, "string \"" + Strings.jsonString(instance.getAsString()) + "\" does not match pattern \"" + Strings.jsonString(value.getAsString()) + "\"");
            return false;
        }
        return true;
    }
}

