/*
 * Decompiled with CFR 0.152.
 */
package com.qindesign.json.schema.keywords;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qindesign.json.schema.Keyword;
import com.qindesign.json.schema.MalformedSchemaException;
import com.qindesign.json.schema.Strings;
import com.qindesign.json.schema.ValidatorContext;
import java.util.HashSet;
import java.util.Map;

public class Properties
extends Keyword {
    public static final String NAME = "properties";

    public Properties() {
        super(NAME);
    }

    @Override
    protected boolean apply(JsonElement value, JsonElement instance, JsonObject parent, ValidatorContext context) throws MalformedSchemaException {
        if (!value.isJsonObject()) {
            context.schemaError("not an object");
            return false;
        }
        if (!instance.isJsonObject()) {
            return true;
        }
        JsonObject schemaObject = value.getAsJsonObject();
        JsonObject object = instance.getAsJsonObject();
        StringBuilder sb = new StringBuilder();
        HashSet<String> validated = new HashSet<String>();
        for (Map.Entry e : object.entrySet()) {
            if (!schemaObject.has((String)e.getKey())) continue;
            if (!context.apply(schemaObject.get((String)e.getKey()), (String)e.getKey(), null, (JsonElement)e.getValue(), (String)e.getKey())) {
                if (context.isFailFast()) {
                    return false;
                }
                if (sb.length() > 0) {
                    sb.append(", \"");
                } else {
                    sb.append("invalid properties: \"");
                }
                sb.append(Strings.jsonString((String)e.getKey())).append('\"');
            }
            validated.add((String)e.getKey());
        }
        context.addAnnotation(NAME, validated);
        context.addLocalAnnotation(NAME, validated);
        if (sb.length() > 0) {
            context.addError(false, sb.toString());
            return false;
        }
        return true;
    }
}

